/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.ServiceOperation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ServiceBinding
extends HashMap<String, Object> {
    public static final String CREDENTIALS = "credentials";
    public static final String SERVICE_INSTANCE_ID = "service_instance_id";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CREATED_AT = "created_at";
    public static final String UPDATED_AT = "updated_at";
    public static final String LABELS = "labels";
    public static final String TENANT_ID = "tenant_id";
    public static final String CERTIFICATE = "certificate";
    public static final String DATABASE_ID = "database_id";
    public static final String DRIVER = "driver";
    public static final String HDI_PASSWORD = "hdi_password";
    public static final String HDI_USER = "hdi_user";
    public static final String HOST = "host";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String SCHEMA = "schema";
    public static final String URL = "url";
    public static final String USER = "user";
    private final ServiceOperation lastOperation;

    public ServiceBinding(Map<String, ?> m) {
        super(m);
        this.lastOperation = new ServiceOperation(m != null ? m : new HashMap());
    }

    public String getId() {
        return this.containsKey(ID) ? (String)this.get(ID) : "";
    }

    public String getName() {
        return this.containsKey(NAME) ? (String)this.get(NAME) : "";
    }

    public String getServiceInstanceId() {
        return this.containsKey(SERVICE_INSTANCE_ID) ? (String)this.get(SERVICE_INSTANCE_ID) : "";
    }

    public Instant getCreatedAt() {
        return Instant.parse((String)this.get(CREATED_AT));
    }

    public Instant getUpdatedAt() {
        return Instant.parse((String)this.get(UPDATED_AT));
    }

    public Map<String, Object> getCredentials() {
        return this.containsKey(CREDENTIALS) ? (Map)this.get(CREDENTIALS) : new HashMap();
    }

    public ServiceOperation getLastOperation() {
        return this.lastOperation;
    }

    public List<String> getTenants() {
        Map labels = (Map)this.get(LABELS);
        if (labels == null) {
            return new ArrayList<String>();
        }
        List tenants = (List)labels.get(TENANT_ID);
        return tenants != null ? tenants.stream().filter(t -> !StringUtils.isBlank((CharSequence)t)).toList() : new ArrayList<String>();
    }

    public boolean hasTenant() {
        return !this.getTenants().isEmpty();
    }

    boolean isUsable() {
        ServiceOperation.Status status = this.lastOperation.getStatus();
        return !this.getCredentials().isEmpty() && (this.lastOperation.getType() != ServiceOperation.Type.CREATE || status != ServiceOperation.Status.FAILED && status != ServiceOperation.Status.IN_PROGRESS);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBinding that = (ServiceBinding)o;
        return Objects.equals(this.lastOperation, that.lastOperation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lastOperation);
    }
}

