/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.BindingParameters;
import com.sap.cds.feature.mt.lib.subscription.HanaAccess;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningParameters;
import com.sap.cds.feature.mt.lib.subscription.ServiceBinding;
import com.sap.cds.feature.mt.lib.subscription.ServiceInstance;
import com.sap.cds.feature.mt.lib.subscription.ServiceManager;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.services.utils.lib.tools.api.ResilienceConfig;
import com.sap.cds.services.utils.lib.tools.api.UuidChecker;
import com.sap.cds.services.utils.lib.tools.impl.Retry;
import com.sap.cds.services.utils.lib.tools.impl.WaitTimeFunction;
import java.lang.ref.Cleaner;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManagerCache
implements HanaAccess {
    private static final String HOST = "host";
    private static BooleanSupplier blockRefresh = () -> false;
    private static Callable<Void> afterFillCache = () -> null;
    private static final Logger logger = LoggerFactory.getLogger(ServiceManagerCache.class);
    private final ServiceManager serviceManager;
    private final ConcurrentHashMap<String, ServiceInstance> cachedServiceInstances = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Instant> lastRead = new ConcurrentHashMap();
    private final AtomicBoolean instancesSelectedOnce = new AtomicBoolean(false);
    private final Retry retryInstance;
    private final Retry retryBinding;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setDaemon(true);
        return t;
    });
    private static final Cleaner cleaner = Cleaner.create();
    private final boolean acceptInstancesWithoutTenant;
    private final boolean ignoreDuplicateTenantInstances;
    private final Duration singleReadInterval;

    public ServiceManagerCache(ServiceManager serviceManager, Duration smCacheRefreshInterval, ResilienceConfig resilienceConfig) {
        this(serviceManager, smCacheRefreshInterval, resilienceConfig, false, false, Duration.ZERO);
    }

    public ServiceManagerCache(ServiceManager serviceManager, Duration smCacheRefreshInterval, ResilienceConfig resilienceConfig, boolean acceptInstancesWithoutTenant, boolean ignoreDuplicateTenantInstances, Duration singleReadInterval, boolean noCacheRefresh) {
        this.acceptInstancesWithoutTenant = acceptInstancesWithoutTenant;
        this.ignoreDuplicateTenantInstances = ignoreDuplicateTenantInstances;
        this.singleReadInterval = singleReadInterval;
        cleaner.register(this, this.executor::shutdownNow);
        this.serviceManager = serviceManager;
        if (smCacheRefreshInterval == null || smCacheRefreshInterval.isZero() || noCacheRefresh) {
            logger.info("Service Manager cache refresher isn't started");
        } else {
            this.startRefreshScheduler(smCacheRefreshInterval);
        }
        WaitTimeFunction waitTimeFunction = resilienceConfig.getWaitTimeFunction();
        this.retryInstance = Retry.RetryBuilder.create().numOfRetries(resilienceConfig.getNumOfRetries()).baseWaitTime(resilienceConfig.getBaseWaitTime()).waitTimeFunction(waitTimeFunction).retryExceptions(new Class[]{InstanceNotReady.class}).build();
        this.retryBinding = Retry.RetryBuilder.create().numOfRetries(resilienceConfig.getNumOfRetries()).baseWaitTime(resilienceConfig.getBaseWaitTime()).waitTimeFunction(waitTimeFunction).retryExceptions(new Class[]{BindingNotReady.class}).build();
    }

    public ServiceManagerCache(ServiceManager serviceManager, Duration smCacheRefreshInterval, ResilienceConfig resilienceConfig, boolean acceptInstancesWithoutTenant, boolean ignoreDuplicateTenantInstances, Duration singleReadInterval) {
        this(serviceManager, smCacheRefreshInterval, resilienceConfig, acceptInstancesWithoutTenant, ignoreDuplicateTenantInstances, singleReadInterval, false);
    }

    @Override
    public Optional<ServiceInstance> getInstance(String tenantId, boolean forceCacheUpdate) throws InternalError {
        ServiceManagerCache.checkTenantId(tenantId);
        ServiceInstance cachedInstance = this.cachedServiceInstances.get(tenantId);
        if (!this.singleReadInterval.isZero() && this.lastRead.containsKey(tenantId) && Duration.between(this.lastRead.get(tenantId), Instant.now()).compareTo(this.singleReadInterval) < 0) {
            logger.debug("Flag forceCacheUpdate is ignored for tenant {} ", (Object)tenantId);
            return cachedInstance != null ? Optional.of(cachedInstance) : Optional.empty();
        }
        if (forceCacheUpdate || cachedInstance == null || !cachedInstance.isUsable() || cachedInstance.getBinding().isEmpty() || !cachedInstance.getBinding().get().isUsable()) {
            if (!this.singleReadInterval.isZero()) {
                this.lastRead.put(tenantId, Instant.now());
            }
            Optional<ServiceInstance> instance = this.getServiceInstanceFromSm(tenantId);
            ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
            if (this.acceptInstancesWithoutTenant && instance.isEmpty()) {
                bindings.addAll(this.serviceManager.readBindingsForTenant(tenantId));
                if (!bindings.isEmpty()) {
                    String instanceId = ((ServiceBinding)bindings.get(0)).getServiceInstanceId();
                    for (ServiceBinding binding : bindings) {
                        if (binding.getServiceInstanceId().equals(instanceId)) continue;
                        throw new InternalError("Binding for tenant %s is assigned to instance %s and not to %s".formatted(tenantId, binding.getServiceInstanceId(), instanceId));
                    }
                    logger.error("Instance with id {} is not labelled with tenant id {} \n Please fix this inconsistency manually", (Object)instanceId, (Object)tenantId);
                    instance = this.serviceManager.readInstance(instanceId);
                    instance.ifPresent(inst -> inst.insertTenant(tenantId));
                }
            }
            if (instance.isEmpty()) {
                this.deleteTenantFromCache(tenantId);
                return Optional.empty();
            }
            if (bindings.isEmpty()) {
                this.getBindingsFromSmAndSetThem(tenantId, instance);
            } else {
                instance.ifPresent(inst -> inst.setBindings(bindings));
            }
            if (this.isCachedBindingNewer(instance.get(), cachedInstance)) {
                return Optional.ofNullable(cachedInstance);
            }
            this.insertAndUpdateInstances(Arrays.asList(instance.get()));
            cachedInstance = this.cachedServiceInstances.get(tenantId);
            if (cachedInstance != null) {
                return Optional.of(cachedInstance);
            }
            return instance;
        }
        return Optional.ofNullable(cachedInstance);
    }

    List<ServiceInstance> getInstances(boolean forceCacheUpdate) throws InternalError {
        if (forceCacheUpdate || !this.instancesSelectedOnce.get()) {
            this.instancesSelectedOnce.set(true);
            List<ServiceInstance> instances = this.serviceManager.readInstances().stream().toList();
            List<ServiceBinding> bindings = this.serviceManager.readBindings().stream().filter(ServiceBinding::hasTenant).toList();
            HashMap instanceIdToBindings = new HashMap();
            bindings.stream().forEach(b -> {
                List bindingList = instanceIdToBindings.computeIfAbsent(b.getServiceInstanceId(), key -> new ArrayList());
                bindingList.add(b);
            });
            instances.stream().forEach(i -> i.setBindings((List)instanceIdToBindings.get(i.getId())));
            if (this.acceptInstancesWithoutTenant) {
                HashMap setTenantIds = new HashMap();
                ArrayList internalErrors = new ArrayList();
                instances.stream().filter(Predicate.not(ServiceInstance::hasTenant)).forEach(i -> i.getBinding().ifPresent(b -> b.getTenants().stream().forEach(tenantId -> {
                    logger.error("Instance with id {} is not labelled with tenant id {} \n Please fix this inconsistency manually", (Object)i.getId(), tenantId);
                    if (setTenantIds.containsKey(tenantId)) {
                        internalErrors.add(new InternalError("Tenant id %s was already set to service instance %s".formatted(tenantId, setTenantIds.get(tenantId))));
                    }
                    i.insertTenant((String)tenantId);
                    setTenantIds.put(tenantId, i.getId());
                })));
                if (!internalErrors.isEmpty()) {
                    throw (InternalError)internalErrors.get(0);
                }
            }
            instances = this.removeDuplicateTenantInstances(instances);
            this.syncCacheWithSmResults(instances);
        }
        return new ArrayList<ServiceInstance>(this.cachedServiceInstances.values());
    }

    @Override
    public List<HanaAccess.TenantInfo> getAllTenants(boolean forceCacheUpdate) throws InternalError {
        return this.getInstances(forceCacheUpdate).stream().flatMap(i -> {
            String databaseId = i.getBinding().isPresent() ? this.getDatabaseId(i.getBinding().get().getCredentials()) : null;
            return i.getTenants().stream().map(t -> new HanaAccess.TenantInfo((String)t, databaseId, i.isUsable()));
        }).toList();
    }

    @Override
    public Set<String> getDatabaseIds(boolean forceCacheUpdate) throws InternalError {
        HashSet<String> databaseIds = new HashSet<String>();
        this.getAllTenants(forceCacheUpdate).stream().filter(t -> !StringUtils.isBlank((CharSequence)t.databaseId())).map(t -> t.databaseId()).forEach(databaseIds::add);
        return databaseIds;
    }

    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        ServiceManagerCache.checkTenantId(tenantId);
        Optional<ServiceInstance> instanceOptional = this.getInstance(tenantId, true);
        this.deleteTenantFromCache(tenantId);
        if (instanceOptional.isEmpty()) {
            return;
        }
        ServiceInstance instance = instanceOptional.get();
        ArrayList<String> errors = new ArrayList<String>();
        instance.getBindings().forEach(binding -> {
            try {
                this.serviceManager.deleteBinding(binding.getId());
            }
            catch (InternalError e) {
                errors.add("Cannot delete binding %s".formatted(binding.getId()));
                errors.add("Cause: %s".formatted(e.getMessage()));
            }
        });
        if (errors.isEmpty()) {
            try {
                this.serviceManager.deleteInstance(instance.getId());
            }
            catch (InternalError e) {
                errors.add("Cannot delete instance %s".formatted(instance.getId()));
                errors.add("Cause: %s".formatted(e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            throw new InternalError(String.join((CharSequence)"\n", errors));
        }
    }

    @Override
    public ServiceInstance createInstance(String tenantId, ProvisioningParameters provisioningParameters, BindingParameters bindingParameters) throws InternalError {
        ServiceManagerCache.checkTenantId(tenantId);
        ServiceInstance instance = this.serviceManager.createInstance(tenantId, provisioningParameters).orElseThrow(() -> new InternalError("No instance returned"));
        Optional<ServiceBinding> binding = this.serviceManager.createBinding(tenantId, instance.getId(), bindingParameters);
        binding.ifPresent(b -> {
            instance.setBindings(Arrays.asList(b));
            this.insertInstanceIntoCache(tenantId, instance);
        });
        return instance;
    }

    @Override
    public void clearCache() {
        this.cachedServiceInstances.clear();
    }

    public static void setAfterFillCache(Callable<Void> afterFillCache) {
        ServiceManagerCache.afterFillCache = afterFillCache;
    }

    private static void checkTenantId(String tenantId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError("Tenant id is null");
        }
    }

    private void getBindingsFromSmAndSetThem(String tenantId, Optional<ServiceInstance> instance) throws InternalError {
        if (instance.isEmpty()) {
            return;
        }
        AtomicReference<ServiceInstance> instanceRef = new AtomicReference<ServiceInstance>(instance.get());
        try {
            this.retryBinding.execute(() -> {
                ((ServiceInstance)instanceRef.get()).setBindings(this.serviceManager.readBindingsForTenant(tenantId));
                if (((ServiceInstance)instanceRef.get()).getBinding().isEmpty()) {
                    throw new BindingNotReady();
                }
            });
        }
        catch (InternalError e) {
            throw e;
        }
        catch (BindingNotReady e) {
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private Optional<ServiceInstance> getServiceInstanceFromSm(String tenantId) throws InternalError {
        Optional instance;
        try {
            instance = (Optional)this.retryInstance.execute(() -> {
                Optional<ServiceInstance> inst = this.serviceManager.readInstanceForTenant(tenantId);
                this.checkInstance(inst);
                return inst;
            });
        }
        catch (InternalError e) {
            throw e;
        }
        catch (InstanceNotReady instanceNotReady) {
            instance = Optional.ofNullable(instanceNotReady.getInstance());
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
        return instance;
    }

    private void syncCacheWithSmResults(List<ServiceInstance> readInstances) {
        Set keysOfReadInstance = readInstances.stream().map(ServiceInstance::getTenants).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<String> deleteKeys = this.cachedServiceInstances.values().stream().map(ServiceInstance::getTenants).flatMap(Collection::stream).filter(Predicate.not(keysOfReadInstance::contains)).collect(Collectors.toSet());
        deleteKeys.forEach(this.cachedServiceInstances::remove);
        this.insertAndUpdateInstances(readInstances);
    }

    private void checkInstance(Optional<ServiceInstance> inst) throws InstanceNotReady {
        if (inst.isEmpty()) {
            logger.debug("Instance is null");
        } else if (!inst.get().isUsable()) {
            throw new InstanceNotReady(inst.get());
        }
    }

    private void insertAndUpdateInstances(List<ServiceInstance> readInstances) {
        readInstances.stream().forEach(instance -> instance.getTenants().forEach(tenantId -> {
            ServiceInstance cachedInstance = this.cachedServiceInstances.get(tenantId);
            if (!this.isCachedBindingNewer((ServiceInstance)instance, cachedInstance)) {
                this.insertInstanceIntoCache((String)tenantId, (ServiceInstance)instance);
            }
        }));
    }

    private boolean isCachedBindingNewer(ServiceInstance instance, ServiceInstance cachedInstance) {
        Optional<Object> cachedBinding;
        Optional<Object> optional = cachedBinding = cachedInstance != null ? cachedInstance.getBinding() : Optional.empty();
        if (cachedBinding.isPresent() && instance.getBinding().isEmpty()) {
            return true;
        }
        return cachedBinding.isPresent() && ((ServiceBinding)cachedBinding.get()).getCreatedAt().isAfter(instance.getBinding().get().getCreatedAt());
    }

    private void startRefreshScheduler(Duration smCacheRefreshInterval) {
        logger.debug("Service Manager cache refresher is started with interval {}", (Object)smCacheRefreshInterval.toMinutes());
        TimerTask refreshSmClientCache = new TimerTask(){

            @Override
            public void run() {
                ServiceManagerCache.this.fillCache();
            }
        };
        this.executor.scheduleAtFixedRate(refreshSmClientCache, 0L, smCacheRefreshInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void fillCache() {
        try {
            if (!blockRefresh.getAsBoolean()) {
                logger.debug("Read all managed instances into instance manager client lib cache");
                List<ServiceInstance> instances = this.getInstances(true);
                if (instances == null || instances.isEmpty()) {
                    logger.debug("Service Manager didn't return service instances");
                }
                afterFillCache.call();
            }
        }
        catch (InternalError e) {
            logger.error("Could not access Service Manager", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Problem with afterFillCache", (Throwable)e);
        }
    }

    private void deleteTenantFromCache(String tenantId) {
        ServiceInstance cachedInstance = this.cachedServiceInstances.remove(tenantId);
        if (cachedInstance != null) {
            this.cachedServiceInstances.entrySet().removeIf(entry -> ((ServiceInstance)entry.getValue()).getId().equals(cachedInstance.getId()));
        }
    }

    private void insertInstanceIntoCache(String tenantId, ServiceInstance instance) {
        ServiceInstance serviceInstanceCopy = instance.createCopy();
        serviceInstanceCopy.clearTenants();
        serviceInstanceCopy.insertTenant(tenantId);
        this.cachedServiceInstances.put(tenantId, serviceInstanceCopy);
    }

    private List<ServiceInstance> removeDuplicateTenantInstances(List<ServiceInstance> instances) {
        if (this.ignoreDuplicateTenantInstances) {
            return instances;
        }
        HashMap tenant2instance = new HashMap();
        HashSet brokenInstances = new HashSet();
        instances.stream().filter(ServiceInstance::hasTenant).forEach(i -> i.getTenants().stream().filter(t -> !t.startsWith("MT_LIB_TENANT-")).forEach(t -> {
            List instanceIdsOfTenant = tenant2instance.computeIfAbsent(t, k -> new ArrayList());
            instanceIdsOfTenant.add(i.getId());
            if (instanceIdsOfTenant.size() > 1) {
                logger.error("Multiple instances for tenant {}.", t);
                instanceIdsOfTenant.stream().forEach(id -> brokenInstances.add(id));
            }
        }));
        return instances.stream().filter(i -> !brokenInstances.contains(i.getId())).toList();
    }

    private String getDatabaseId(Map<String, Object> credentials) {
        String databaseId = (String)credentials.get("database_id");
        if (StringUtils.isNotEmpty((CharSequence)databaseId)) {
            return databaseId;
        }
        databaseId = StringUtils.substringBefore((String)((String)credentials.get(HOST)), (String)".");
        return UuidChecker.isUUId((String)databaseId) ? databaseId : null;
    }

    private class InstanceNotReady
    extends Exception {
        private final ServiceInstance instance;

        public InstanceNotReady(ServiceInstance instance) {
            this.instance = instance;
        }

        public ServiceInstance getInstance() {
            return this.instance;
        }
    }

    private class BindingNotReady
    extends Exception {
        private BindingNotReady() {
        }
    }
}

