/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.BindingParameters;
import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import com.sap.cds.feature.mt.lib.subscription.DbDeployer;
import com.sap.cds.feature.mt.lib.subscription.FilterTenants;
import com.sap.cds.feature.mt.lib.subscription.HanaEncryptionTool;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningParameters;
import com.sap.cds.feature.mt.lib.subscription.SaasRegistry;
import com.sap.cds.feature.mt.lib.subscription.SecurityChecker;
import com.sap.cds.feature.mt.lib.subscription.ServiceCreateOptions;
import com.sap.cds.feature.mt.lib.subscription.Subscriber;
import com.sap.cds.feature.mt.lib.subscription.SubscriptionPayloadAccess;
import com.sap.cds.feature.mt.lib.subscription.Tools;
import com.sap.cds.feature.mt.lib.subscription.exceptions.AuthorityError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.NotSupported;
import com.sap.cds.feature.mt.lib.subscription.exceptions.ParameterError;
import com.sap.cds.feature.mt.lib.subscription.exceptions.UnknownTenant;
import com.sap.cds.feature.mt.lib.subscription.exits.AfterSubscribeMethod;
import com.sap.cds.feature.mt.lib.subscription.exits.AfterUnSubscribeMethod;
import com.sap.cds.feature.mt.lib.subscription.exits.Exits;
import com.sap.cds.feature.mt.lib.subscription.json.ApplicationDependency;
import com.sap.cds.feature.mt.lib.subscription.json.Cloner;
import com.sap.cds.feature.mt.lib.subscription.json.DeletePayload;
import com.sap.cds.feature.mt.lib.subscription.json.SubscriptionPayload;
import com.sap.cds.services.utils.lib.tools.api.ResilienceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberImpl
implements Subscriber {
    public static final String ALL_TENANTS = "all";
    private static final Logger logger = LoggerFactory.getLogger(SubscriberImpl.class);
    private final InstanceLifecycleManager instanceLifecycleManager;
    private final DbDeployer dbDeployer;
    private final Exits exits;
    private final String baseUiUrl;
    private final String urlSeparator;
    private final SecurityChecker securityChecker;
    private final SaasRegistry saasRegistry;
    private final boolean withoutAuthorityCheck;
    private final HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode;
    private final ResilienceConfig resilienceConfig;

    SubscriberImpl(InstanceLifecycleManager instanceLifecycleManager, DbDeployer dbDeployer, String baseUiUrl, String urlSeparator, Exits exits, SecurityChecker securityChecker, SaasRegistry saasRegistry, boolean withoutAuthorityCheck, HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode, ResilienceConfig resilienceConfig) throws InternalError {
        this.resilienceConfig = resilienceConfig != null ? resilienceConfig : ResilienceConfig.NONE;
        this.instanceLifecycleManager = instanceLifecycleManager;
        this.dbDeployer = dbDeployer;
        this.exits = exits;
        this.baseUiUrl = baseUiUrl;
        this.urlSeparator = urlSeparator;
        if (exits.getUnSubscribeExit() == null) {
            throw new InternalError("No unsubscribe exit found");
        }
        this.securityChecker = securityChecker;
        this.saasRegistry = saasRegistry;
        this.withoutAuthorityCheck = withoutAuthorityCheck;
        this.hanaEncryptionMode = hanaEncryptionMode;
    }

    @Override
    public void unsubscribe(String tenantId, DeletePayload deletePayload) throws InternalError, ParameterError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        Tools.checkExternalTenantId(tenantId);
        boolean processUnsubscribe = this.exits.getBeforeUnSubscribeMethod().call(tenantId, Cloner.clone(deletePayload));
        if (processUnsubscribe) {
            this.deleteInstance(tenantId, deletePayload, this.exits.getAfterUnSubscribeMethod());
        } else {
            logger.debug("Unsubscribe exit returned false=> No unsubscription performed");
        }
    }

    @Override
    public List<ApplicationDependency> getApplicationDependencies() throws AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        return this.exits.getDependencyExit().onGetDependencies();
    }

    @Override
    public String subscribe(String tenantId, SubscriptionPayload subscriptionPayload) throws InternalError, ParameterError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        Tools.checkExternalTenantId(tenantId);
        ServiceCreateOptions serviceCreateOptions = null;
        try {
            serviceCreateOptions = new ServiceCreateOptions(this.exits.getBeforeSubscribeMethod().call(tenantId, Cloner.clone(subscriptionPayload)));
        }
        catch (InternalError internalError) {
            this.exits.getAfterSubscribeMethod().call(tenantId, Cloner.clone(subscriptionPayload), false);
            throw internalError;
        }
        String subscriptionUrl = Tools.getApplicationUrl(subscriptionPayload, this.exits.getSubscribeExit()::uiURL, this.exits.getSubscribeExit()::uiURL, this.baseUiUrl, this.urlSeparator);
        SubscriptionPayloadAccess payloadAccess = SubscriptionPayloadAccess.create(subscriptionPayload.getMap());
        HanaEncryptionTool.addEncryptionParameter(serviceCreateOptions, this.hanaEncryptionMode, payloadAccess);
        this.createInstanceAndOnBoard(tenantId, subscriptionPayload, subscriptionUrl, serviceCreateOptions, this.exits.getAfterSubscribeMethod(), this.resilienceConfig);
        return subscriptionUrl;
    }

    @Override
    public String getSubscribeUrl(SubscriptionPayload subscriptionPayload) throws InternalError, ParameterError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkSubscriptionAuthority();
        }
        return Tools.getApplicationUrl(subscriptionPayload, this.exits.getSubscribeExit()::uiURL, this.exits.getSubscribeExit()::uiURL, this.baseUiUrl, this.urlSeparator);
    }

    @Override
    public void setupDbTables(List<String> tenants) throws InternalError, ParameterError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        this.setupDbTablesInt(tenants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setupDbTablesAsync(List<String> tenants) throws ParameterError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        for (String tenantId : tenants) {
            Tools.checkExternalTenantId(tenantId);
        }
        ExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadExecutor();
            CompletableFuture.supplyAsync(() -> {
                try {
                    this.setupDbTablesInt(tenants);
                }
                catch (InternalError internalError) {
                    logger.error("Could not init DB asynchronously. Error is {}", (Object)internalError.getMessage());
                }
                catch (AuthorityError | ParameterError exception) {
                    // empty catch block
                }
                return "";
            }, executor);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return "";
    }

    @Override
    public String updateStatus(String jobId) throws NotSupported, InternalError, AuthorityError {
        if (!this.withoutAuthorityCheck) {
            this.securityChecker.checkInitDbAuthority();
        }
        logger.debug("Update status is only supported with sidecar");
        throw new NotSupported("Update status is only supported with sidecar");
    }

    @Override
    public void callSaasRegistry(boolean ok, String message, String applicationUrl, String saasRegistryUrl) throws InternalError {
        this.saasRegistry.callBackSaasRegistry(ok, message, applicationUrl, saasRegistryUrl);
    }

    @Override
    public void checkAuthority(SecurityChecker.Authority authority) throws AuthorityError {
        this.securityChecker.checkAuthority(authority);
    }

    private void setupDbTablesInt(List<String> tenants) throws InternalError, ParameterError, AuthorityError {
        for (String tenantId2 : tenants) {
            Tools.checkExternalTenantId(tenantId2);
        }
        if (tenants.size() == 1 && tenants.get(0).equals(ALL_TENANTS)) {
            this.setupDbTables(new ArrayList<String>(this.instanceLifecycleManager.getAllTenants(true)));
            return;
        }
        if (this.exits.getInitDbExit() != null) {
            this.exits.getInitDbExit().onBeforeInitDb(tenants);
        }
        String[] message = new String[]{""};
        tenants.stream().filter(FilterTenants.realTenants()).forEach(tenantId -> {
            try {
                DataSourceInfo dataSourceAndInfo = this.instanceLifecycleManager.getDataSourceInfo((String)tenantId, false);
                this.dbDeployer.populate(dataSourceAndInfo, (String)tenantId);
            }
            catch (InternalError e) {
                if (message[0].isEmpty()) {
                    message[0] = "Error in deployment:";
                }
                message[0] = message[0] + "\n Could not perform deployment for tenant " + tenantId + " Error is:" + e.getMessage();
            }
            catch (UnknownTenant unknownTenant) {
                // empty catch block
            }
        });
        if (this.exits.getInitDbExit() != null) {
            this.exits.getInitDbExit().onAfterInitDb(message[0].isEmpty());
        }
        if (!message[0].isEmpty()) {
            throw new InternalError(message[0]);
        }
    }

    private void deleteInstance(String tenantId, DeletePayload deletePayload, AfterUnSubscribeMethod afterUnSubscribeMethod) throws InternalError {
        this.instanceLifecycleManager.deleteInstance(tenantId);
        afterUnSubscribeMethod.call(tenantId, Cloner.clone(deletePayload));
    }

    private String createInstanceAndOnBoard(String tenantId, SubscriptionPayload subscriptionPayload, String url, ServiceCreateOptions serviceCreateOptions, AfterSubscribeMethod exit, ResilienceConfig resilienceConfig) throws InternalError {
        AtomicReference<Object> instanceStatusRef = new AtomicReference<Object>(null);
        resilienceConfig.tryWhile(() -> {
            try {
                instanceStatusRef.set(this.instanceLifecycleManager.getContainerStatus(tenantId));
                return instanceStatusRef.get() == InstanceLifecycleManager.ContainerStatus.CREATION_IN_PROGRESS || instanceStatusRef.get() == InstanceLifecycleManager.ContainerStatus.OK && !this.instanceLifecycleManager.hasCredentials(tenantId, false);
            }
            catch (InternalError e) {
                logger.error("Could not get status for tenant %s".formatted(tenantId), (Throwable)e);
                return true;
            }
        });
        InstanceLifecycleManager.ContainerStatus instanceStatus = instanceStatusRef.get();
        if (instanceStatus == InstanceLifecycleManager.ContainerStatus.CREATION_ERROR) {
            logger.debug("Container for tenant {} has status CREATION_FAILED", (Object)tenantId);
            logger.debug("Delete container to fix problem");
            this.instanceLifecycleManager.deleteInstance(tenantId);
            instanceStatus = this.instanceLifecycleManager.getContainerStatus(tenantId);
        }
        logger.debug("Subscribe tenant {}", (Object)tenantId);
        if (instanceStatus == InstanceLifecycleManager.ContainerStatus.OK) {
            this.deploy(tenantId, subscriptionPayload, exit);
            return url;
        }
        if (instanceStatus == InstanceLifecycleManager.ContainerStatus.DOES_NOT_EXIST) {
            logger.debug("Create new instance for tenant {}", (Object)tenantId);
            ProvisioningParameters provisioningParameters = new ProvisioningParameters(serviceCreateOptions.getProvisioningParameters());
            BindingParameters bindingParameters = new BindingParameters(serviceCreateOptions.getBindingParameters());
            try {
                this.instanceLifecycleManager.createNewInstance(tenantId, provisioningParameters, bindingParameters);
            }
            catch (InternalError internalError) {
                exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
                throw internalError;
            }
            this.deploy(tenantId, subscriptionPayload, exit);
            return url;
        }
        logger.error("Instance for tenant id {} has wrong status {}", (Object)tenantId, (Object)instanceStatus);
        exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
        throw new InternalError("Instance has wrong status");
    }

    private void deploy(String tenantId, SubscriptionPayload subscriptionPayload, AfterSubscribeMethod exit) throws InternalError {
        try {
            DataSourceInfo dataSourceInfo = this.instanceLifecycleManager.getDataSourceInfo(tenantId, false);
            logger.debug("Deploy to DB container for tenant {}", (Object)tenantId);
            this.dbDeployer.populate(dataSourceInfo, tenantId);
            exit.call(tenantId, Cloner.clone(subscriptionPayload), true);
        }
        catch (UnknownTenant unknownTenant) {
            logger.error("Tenant {} was deleted in parallel session", (Object)tenantId);
            exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
            throw new InternalError("Tenant was deleted in parallel session");
        }
        catch (InternalError internalError) {
            logger.error("Could not deploy to DB container for tenant {}", (Object)tenantId);
            exit.call(tenantId, Cloner.clone(subscriptionPayload), false);
            throw internalError;
        }
    }

    public DbDeployer getDbDeployer() {
        return this.dbDeployer;
    }
}

