/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription.hana.mt.service;

import com.sap.cds.feature.mt.lib.subscription.ServiceBinding;
import com.sap.cds.feature.mt.lib.subscription.ServiceInstance;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Credential;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Status;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Tools;
import com.sap.cds.services.utils.lib.tools.api.QueryParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Container
extends HashMap<String, Object> {
    private static final String LABELS_NODE = "labels";
    private static final String TENANT_ID = "tenant_id";
    private static final String STATUS_NODE = "status";
    private static final String ID_NODE = "id";
    private static final String CREDENTIALS_NODE = "credentials";
    private static final String TYPE_NODE = "type";
    private static final String HDI_TYPE = "hdi";
    private static final String MAKE_UNIQUE_NAME_NODE = "makeUniqueName";
    private static final String TENANT_ID_TEMPLATE = "tenant_id=%s";
    private static final String EXPAND_PARAMETER = "$expand";
    private static final String EXPAND_CREDENTIALS = "credentials";
    private static final String DATA_NODE = "data";
    private final List<Credential> credentials = new ArrayList<Credential>();

    public Container(Map<String, ?> m) {
        super(m);
        if (this.containsKey("credentials")) {
            Tools.asListMap(this.get("credentials")).stream().forEach((? super T credentialData) -> this.credentials.add(new Credential((Map<String, Object>)credentialData)));
        }
    }

    public static Map<String, Object> createCreatePayload(String tenantId) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TYPE_NODE, HDI_TYPE);
        payload.put(MAKE_UNIQUE_NAME_NODE, false);
        List<String> labels = List.of(TENANT_ID_TEMPLATE.formatted(tenantId));
        payload.put(LABELS_NODE, labels);
        return payload;
    }

    public static QueryParameter getExpandCredentials() {
        return new QueryParameter(EXPAND_PARAMETER, "credentials");
    }

    public static List<Container> getContainersFromPayload(Map<String, Object> payload) {
        ArrayList<Container> containers = new ArrayList<Container>();
        if (payload.containsKey(DATA_NODE)) {
            Tools.asListMap(payload.get(DATA_NODE)).forEach((? super T c) -> containers.add(new Container((Map<String, ?>)c)));
        }
        return containers;
    }

    public String getBtpTenant() throws InternalError {
        List labels = (List)this.get(LABELS_NODE);
        if (labels == null || labels.isEmpty()) {
            throw new InternalError("No label section");
        }
        Optional<String> labelOpt = labels.stream().filter(l -> l.contains(TENANT_ID)).findFirst();
        String label = labelOpt.orElseThrow(() -> new InternalError("No btp tenant id is set"));
        String[] parts = label.split("=");
        if (parts.length < 2 || StringUtils.isBlank((CharSequence)parts[1])) {
            throw new InternalError("No btp tenant id is set");
        }
        return parts[1];
    }

    public Status getStatus() {
        return new Status(Tools.asMap(this.get(STATUS_NODE)));
    }

    public String getId() {
        if (!this.containsKey(ID_NODE)) {
            return "";
        }
        return (String)this.get(ID_NODE);
    }

    public List<Credential> getCredentials() {
        return this.credentials;
    }

    public void insertCredentials(List<Credential> credentials) {
        this.credentials.addAll(credentials);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Container container = (Container)o;
        return Objects.equals(this.credentials, container.credentials);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.credentials);
    }

    public ServiceInstance toServiceInstance() {
        HashMap<String, Object> instanceMap = new HashMap<String, Object>();
        instanceMap.put(ID_NODE, this.getId());
        instanceMap.put("usable", this.getStatus().isReady());
        ServiceInstance instance = new ServiceInstance((Map<String, ?>)instanceMap);
        instance.insertTenant(this.getBtpTenant());
        instance.setBindings(this.toServiceBindings());
        return instance;
    }

    public List<ServiceBinding> toServiceBindings() {
        ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
        if (this.credentials.isEmpty()) {
            return bindings;
        }
        this.credentials.forEach((? super T credential) -> {
            HashMap<String, Object> bindingMap = new HashMap<String, Object>();
            bindingMap.put(ID_NODE, credential.getId());
            bindingMap.put("service_instance_id", this.getId());
            bindingMap.put(LABELS_NODE, Collections.singletonMap(TENANT_ID, this.getBtpTenant()));
            HashMap<String, String> targetCredentials = new HashMap<String, String>();
            targetCredentials.put("certificate", credential.getCertificate());
            targetCredentials.put("database_id", credential.getDatabaseId());
            targetCredentials.put("driver", credential.getDriver());
            targetCredentials.put("hdi_password", credential.getHdiPassword());
            targetCredentials.put("hdi_user", credential.getHdiUser());
            targetCredentials.put("host", credential.getHost());
            targetCredentials.put("password", credential.getPassword());
            targetCredentials.put("port", credential.getPort());
            targetCredentials.put("schema", credential.getSchema());
            targetCredentials.put("url", credential.getUrl());
            targetCredentials.put("user", credential.getUser());
            bindingMap.put("credentials", targetCredentials);
            bindings.add(new ServiceBinding((Map<String, ?>)bindingMap));
        });
        return bindings;
    }
}

