/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription.hana.mt.service;

import com.sap.cds.feature.mt.MtUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.net.URI;
import java.util.Collections;

public class HanaMtPropertySupplier
extends DefaultOAuth2PropertySupplier {
    public static final String API_URL = "baseurl";
    public static final String HANA_MULTITENANCY_PLAN = "hana-multitenancy";
    public static final String OAUTH_PATH = "uaa";
    public static final String HANA_CLOUD = "hana-cloud";
    private static volatile boolean initialized = false;

    public HanaMtPropertySupplier(ServiceBindingDestinationOptions options) {
        super(options, Collections.singletonList(OAUTH_PATH));
    }

    public static synchronized void initialize() {
        if (!initialized) {
            OAuth2ServiceBindingDestinationLoader.registerPropertySupplier(HanaMtPropertySupplier::matches, HanaMtPropertySupplier::new);
            initialized = true;
        }
    }

    private static boolean matches(ServiceBindingDestinationOptions options) {
        ServiceBinding binding = options.getServiceBinding();
        return MtUtils.isHanaMtServiceBinding(binding);
    }

    public URI getServiceUri() {
        URI uri;
        Object baseUrl = (String)this.getCredentialOrThrow(String.class, new String[]{API_URL});
        if (!((String)baseUrl).startsWith("http://") && !((String)baseUrl).startsWith("https://")) {
            baseUrl = "https://" + (String)baseUrl;
        }
        try {
            uri = URI.create((String)baseUrl);
        }
        catch (IllegalArgumentException e) {
            throw new DestinationAccessException((Throwable)e);
        }
        return uri;
    }
}

