/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription.hana.mt.service;

import com.sap.cds.feature.mt.lib.subscription.BindingParameters;
import com.sap.cds.feature.mt.lib.subscription.HanaAccess;
import com.sap.cds.feature.mt.lib.subscription.PollingParameters;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningParameters;
import com.sap.cds.feature.mt.lib.subscription.ServiceInstance;
import com.sap.cds.feature.mt.lib.subscription.ServiceSpecification;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Container;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.ContainerIdWithResponseCode;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.ContainerWithEtag;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.ContainersWithEtag;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Credential;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.CredentialIdWithResponseCode;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.CredentialWithEtag;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.CredentialsWithEtag;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.HanaMtPropertySupplier;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.HanaTenant;
import com.sap.cds.services.utils.lib.tools.api.QueryParameter;
import com.sap.cds.services.utils.lib.tools.api.ServiceCall;
import com.sap.cds.services.utils.lib.tools.api.ServiceEndpoint;
import com.sap.cds.services.utils.lib.tools.api.ServiceResponse;
import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import com.sap.cds.services.utils.lib.tools.exception.ServiceException;
import com.sap.cds.services.utils.lib.tools.impl.Wrap;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Options;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaMtService
implements HanaAccess {
    private static final Logger logger = LoggerFactory.getLogger(HanaMtService.class);
    private static final String TENANTS_ENDPOINT = "/tenants/v2/tenants";
    private static final String CONTAINERS_ENDPOINT = "/tenants/v2/tenants/%s/containers";
    private static final String CONTAINER_ENDPOINT = "/tenants/v2/tenants/%s/containers/%s";
    private static final String CREDENTIALS_ENDPOINT = "/tenants/v2/tenants/%s/containers/%s/credentials";
    private static final String CREDENTIAL_ENDPOINT = "/tenants/v2/tenants/%s/containers/%s/credentials/%s";
    private static final String UNEXPECTED_RETURN_CODE = "unexpected return code %d";
    private static final String BASEURL = "baseurl";
    private static final String SKIPTOKEN = "$skiptoken";
    private static final String LOCATION = "location";
    private static final String IF_MATCH = "If-Match";
    private static final String NO_ETAG_RETURNED = "No etag returned";
    private static final String HANA_TENANT_ID_IN_PROVISIONING = "hana_tenant_id";
    private final ServiceEndpoint hanaTenantsEndpoint;
    private final ServiceEndpoint containersEndpoint;
    private final ServiceEndpoint containerEndpoint;
    private final ServiceEndpoint credentialsEndpoint;
    private final ServiceEndpoint credentialEndpoint;
    private final ServiceSpecification serviceSpecification;
    private final ServiceBinding hanaMtBinding;
    private final AtomicBoolean dbIdsInitialized = new AtomicBoolean(false);
    private final Set<String> dbIds = ConcurrentHashMap.newKeySet();
    private final String serviceBindingName;
    private final String hanaTenantPrefix;

    public HanaMtService(ServiceBinding serviceBinding, ServiceSpecification serviceSpecification, Duration oauthTimeout, String hanaTenantPrefix) throws InternalError {
        this.serviceSpecification = serviceSpecification;
        this.hanaMtBinding = serviceBinding;
        this.serviceBindingName = (String)serviceBinding.getName().orElseThrow(() -> new InternalError("Service binding name is missing"));
        this.hanaTenantPrefix = hanaTenantPrefix;
        HashSet<Integer> retryCodes = new HashSet<Integer>();
        retryCodes.add(502);
        retryCodes.add(504);
        retryCodes.add(500);
        retryCodes.add(503);
        HttpDestination destination = this.getDestination(serviceBinding, oauthTimeout);
        try {
            this.hanaTenantsEndpoint = this.createEndpoint(destination, TENANTS_ENDPOINT, new HashSet<Integer>(List.of(Integer.valueOf(200), Integer.valueOf(202), Integer.valueOf(204))), retryCodes);
            this.containersEndpoint = this.createEndpoint(destination, CONTAINERS_ENDPOINT, new HashSet<Integer>(List.of(Integer.valueOf(200), Integer.valueOf(202), Integer.valueOf(204), Integer.valueOf(409))), retryCodes);
            this.containerEndpoint = this.createEndpoint(destination, CONTAINER_ENDPOINT, new HashSet<Integer>(List.of(Integer.valueOf(200), Integer.valueOf(202), Integer.valueOf(204), Integer.valueOf(409))), retryCodes);
            this.credentialsEndpoint = this.createEndpoint(destination, CREDENTIALS_ENDPOINT, new HashSet<Integer>(List.of(Integer.valueOf(200), Integer.valueOf(202), Integer.valueOf(204), Integer.valueOf(409))), retryCodes);
            this.credentialEndpoint = this.createEndpoint(destination, CREDENTIAL_ENDPOINT, new HashSet<Integer>(List.of(Integer.valueOf(200), Integer.valueOf(202), Integer.valueOf(204), Integer.valueOf(409))), retryCodes);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public Optional<ServiceInstance> getInstance(String tenantId, boolean forceCacheUpdate) throws InternalError {
        this.checkTenantId(tenantId);
        Optional<HanaTenant> hanaTenantOpt = this.getOneHanaTenantViaBtpTenantId(tenantId);
        if (hanaTenantOpt.isEmpty()) {
            return Optional.empty();
        }
        HanaTenant hanaTenant = hanaTenantOpt.get();
        this.dbIds.add(hanaTenant.getDatabaseId());
        List<Container> containers = hanaTenant.getContainers().stream().filter(c -> tenantId.equals(c.getBtpTenant())).toList();
        if (containers.size() > 1) {
            throw new InternalError("Multiple HDI containers found for BTP tenant id {}".formatted(tenantId));
        }
        if (containers.isEmpty()) {
            logger.debug("No container found for HANA tenant {}", (Object)hanaTenant.getId());
            return Optional.empty();
        }
        Container container = containers.get(0);
        logger.debug("Container {} read with {} credentials", (Object)container.getId(), (Object)container.getCredentials().size());
        container.getCredentials().forEach(c -> logger.debug("user = {} ,  hdiUser = {} , schema = {}", new Object[]{c.getUser(), c.getHdiUser(), c.getSchema()}));
        return Optional.of(containers.get(0).toServiceInstance());
    }

    @Override
    public List<HanaAccess.TenantInfo> getAllTenants(boolean forceCacheUpdate) throws InternalError {
        throw new InternalError("Method getAllTenants isn't supported for HANA multi tenant service v2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDatabaseIds(boolean forceCacheUpdate) throws InternalError {
        if (forceCacheUpdate || !this.dbIdsInitialized.get()) {
            HanaMtService hanaMtService = this;
            synchronized (hanaMtService) {
                if (forceCacheUpdate || !this.dbIdsInitialized.get()) {
                    this.dbIds.addAll(this.readHanaTenants(null, null, false).stream().map(HanaTenant::getDatabaseId).filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
                    this.dbIdsInitialized.set(true);
                }
            }
        }
        return new HashSet<String>(this.dbIds);
    }

    @Override
    public void deleteInstance(String tenantId) throws InternalError {
        this.checkTenantId(tenantId);
        Optional<HanaTenant> hanaTenantOpt = this.getOneHanaTenantViaBtpTenantId(tenantId);
        if (hanaTenantOpt.isEmpty()) {
            return;
        }
        HanaTenant hanaTenant = hanaTenantOpt.get();
        for (Container container : hanaTenant.getContainers()) {
            for (Credential credential : container.getCredentials()) {
                this.deleteCredential(hanaTenant.getId(), container.getId(), credential.getId());
            }
            this.waitForCredentialDeletion(container, hanaTenant);
            this.deleteContainer(hanaTenant.getId(), container.getId());
            this.checkThatContainersWereDeleted(hanaTenant);
        }
    }

    @Override
    public ServiceInstance createInstance(String tenantId, ProvisioningParameters provisioningParameters, BindingParameters bindingParameters) throws InternalError {
        logger.debug("Create a new service instance for btp tenant id {}", (Object)tenantId);
        PollingParameters polling = this.serviceSpecification.getPolling();
        Wrap hanaTenantWrap = Wrap.wrapEmpty(HanaTenant.class);
        logger.debug("Poll until HANA tenant is created");
        polling.pollUntil(this.untilHanaTenantIsReadOrCreated(tenantId, (Wrap<HanaTenant>)hanaTenantWrap, provisioningParameters));
        HanaTenant hanaTenant = (HanaTenant)hanaTenantWrap.orElseThrow(() -> new InternalError("HANA tenant couldn't be created"));
        this.dbIds.add(hanaTenant.getDatabaseId());
        Wrap containerWithEtagWrap = Wrap.wrapEmpty(ContainerWithEtag.class);
        logger.debug("Poll until container is created for HANA tenant {}", (Object)hanaTenant.getId());
        polling.pollUntil(this.untilContainerIsReadOrCreated(tenantId, hanaTenant.getId(), (Wrap<ContainerWithEtag>)containerWithEtagWrap));
        Container container = ((ContainerWithEtag)containerWithEtagWrap.get()).container().orElseThrow(() -> new InternalError("HDI container couldn't be created"));
        Wrap credentialWithEtagWrap = Wrap.wrapEmpty(CredentialWithEtag.class);
        logger.debug("Poll until credential is created for HANA tenant {} and container {}", (Object)hanaTenant.getId(), (Object)container.getId());
        polling.pollUntil(this.untilCredentialIsReady(hanaTenant.getId(), container.getId(), (Wrap<CredentialWithEtag>)credentialWithEtagWrap));
        Credential credential = ((CredentialWithEtag)credentialWithEtagWrap.get()).credential().orElseThrow(() -> new InternalError("Credential couldn't be created"));
        container.insertCredentials(List.of(credential));
        return container.toServiceInstance();
    }

    @Override
    public void clearCache() {
        this.dbIds.clear();
    }

    public String getServiceBindingName() {
        return this.serviceBindingName;
    }

    private void waitForCredentialDeletion(Container container, HanaTenant hanaTenant) throws InternalError {
        Wrap credentialsSizeWrap = Wrap.wrapEmpty(Integer.class);
        this.serviceSpecification.getPolling().pollUntil(first -> {
            try {
                List<Credential> credentials = this.readCredentials(hanaTenant.getId(), container.getId()).credentials();
                credentialsSizeWrap.set((Object)credentials.size());
                return credentials.isEmpty();
            }
            catch (InternalError e) {
                logger.error("An exception occurred during credential read", (Throwable)e);
                return true;
            }
        });
        if (credentialsSizeWrap.isEmpty() || (Integer)credentialsSizeWrap.get() != 0) {
            throw new InternalError("Not all credentials could be deleted");
        }
    }

    @NotNull
    private PollingParameters.Until<InternalError> untilHanaTenantIsReadOrCreated(String tenantId, Wrap<HanaTenant> hanaTenantWrap, ProvisioningParameters provisioningParameters) {
        Wrap hanaTenantIdWrap = Wrap.wrapEmpty(String.class);
        return first -> {
            if (first) {
                List<HanaTenant> hanaTenants = this.readHanaTenants(null, tenantId, true);
                if (hanaTenants.size() > 1) {
                    throw new InternalError("Multiple HANA tenants found for tenant id %s".formatted(tenantId));
                }
                if (!hanaTenants.isEmpty()) {
                    hanaTenantIdWrap.set((Object)hanaTenants.get(0).getId());
                    hanaTenantWrap.set((Object)hanaTenants.get(0));
                }
            } else {
                Optional<HanaTenant> hanaTenantOpt = this.readHanaTenant((String)hanaTenantIdWrap.get(), false);
                if (hanaTenantOpt.isPresent()) {
                    hanaTenantWrap.set((Object)hanaTenantOpt.get());
                }
            }
            if (hanaTenantIdWrap.isEmpty()) {
                hanaTenantIdWrap.set((Object)this.createHanaTenant(tenantId, provisioningParameters));
            }
            return hanaTenantWrap.isPresent() && ((HanaTenant)hanaTenantWrap.get()).getStatus().isReady();
        };
    }

    @NotNull
    private PollingParameters.Until<InternalError> untilContainerIsReadOrCreated(String tenantId, String hanaTenantId, Wrap<ContainerWithEtag> containerWithEtagWrap) {
        Wrap createRequestedWrap = Wrap.wrap((Object)false);
        return first -> {
            containerWithEtagWrap.set((Object)this.readOneContainer(hanaTenantId, tenantId, false));
            if (((ContainerWithEtag)containerWithEtagWrap.get()).container().isEmpty() && !Boolean.TRUE.equals(createRequestedWrap.get())) {
                createRequestedWrap.set((Object)true);
                int responseCode = this.createContainer(hanaTenantId, tenantId, ((ContainerWithEtag)containerWithEtagWrap.get()).etag()).responseCode();
                if (responseCode == 409) {
                    createRequestedWrap.set((Object)false);
                }
            }
            return ((ContainerWithEtag)containerWithEtagWrap.get()).container().isPresent() && ((ContainerWithEtag)containerWithEtagWrap.get()).container().get().getStatus().isReady();
        };
    }

    @NotNull
    private PollingParameters.Until<InternalError> untilCredentialIsReady(String hanaTenantId, String containerId, Wrap<CredentialWithEtag> credentialWithEtagWrap) {
        Wrap createRequestedWrap = Wrap.wrap((Object)false);
        return first -> {
            logger.debug("Repeat util credential for container {} is ready", (Object)containerId);
            CredentialWithEtag credentialWithEtag = this.readNewestWorkingCredential(hanaTenantId, containerId);
            credentialWithEtagWrap.set((Object)credentialWithEtag);
            if (credentialWithEtag.credential().isEmpty() && !Boolean.TRUE.equals(createRequestedWrap.get())) {
                logger.debug("No credential found: Create a new one.");
                createRequestedWrap.set((Object)true);
                int responseCode = this.createCredential(hanaTenantId, containerId, ((CredentialWithEtag)credentialWithEtagWrap.get()).etag()).responseCode();
                if (responseCode == 409) {
                    createRequestedWrap.set((Object)false);
                }
            }
            logger.debug("Credential is present = {}, Credential is valid = {}", (Object)credentialWithEtag.credential().isPresent(), (Object)(credentialWithEtag.credential().isPresent() ? credentialWithEtag.credential().get().isValid() : false));
            return credentialWithEtag.credential().isPresent() && credentialWithEtag.credential().get().isValid();
        };
    }

    private ContainerWithEtag readOneContainer(String hanaTenantId, String tenantId, boolean withExpand) throws InternalError {
        ContainersWithEtag containersWithEtag = this.readContainers(hanaTenantId, withExpand);
        List<Container> containers = containersWithEtag.containers();
        logger.debug("For HANA tenant {}, {} containers were read", (Object)hanaTenantId, (Object)containers.size());
        if (containers.isEmpty()) {
            return new ContainerWithEtag(Optional.empty(), containersWithEtag.etag());
        }
        if (containers.size() != 1) {
            throw new InternalError("Several HDI containers exist for Hana tenant %s ".formatted(hanaTenantId));
        }
        Container container = containers.get(0);
        if (!container.getBtpTenant().equals(tenantId)) {
            throw new InternalError("Container is assigned to the wrong tenant id %s".formatted(container.getBtpTenant()));
        }
        if (containersWithEtag.etag().isBlank()) {
            throw new InternalError("Container etag is blank");
        }
        return new ContainerWithEtag(Optional.of(container), containersWithEtag.etag());
    }

    private CredentialWithEtag readNewestWorkingCredential(String hanaTenantId, String containerId) throws InternalError {
        CredentialsWithEtag credentialsWithEtag = this.readCredentials(hanaTenantId, containerId);
        List<Credential> credentials = credentialsWithEtag.credentials();
        if (credentials.isEmpty()) {
            return new CredentialWithEtag(Optional.empty(), credentialsWithEtag.etag());
        }
        if (credentialsWithEtag.etag().isBlank()) {
            throw new InternalError("Container etag is blank");
        }
        return new CredentialWithEtag(credentials.stream().filter(Credential::isValid).reduce((a, b) -> b), credentialsWithEtag.etag());
    }

    private ServiceEndpoint createEndpoint(HttpDestination destination, String path, Set<Integer> expectedResponseCodes, Set<Integer> retryCodes) throws InternalException {
        return ServiceEndpoint.create().destination(destination).path(path).returnCodeChecker(c -> {
            if (!expectedResponseCodes.contains(c)) {
                return new InternalError(UNEXPECTED_RETURN_CODE.formatted(c));
            }
            return null;
        }).retry().forReturnCodes(retryCodes).config(this.serviceSpecification.getResilienceConfig()).end();
    }

    private List<HanaTenant> readHanaTenants(String skipToken, String tenantId, boolean withExpand) throws InternalError {
        logger.debug("Determine Hana tenants for BTP tenant id {} and skipToken {}", (Object)tenantId, (Object)skipToken);
        try {
            ArrayList<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                queryParameters.add(HanaTenant.getContainerQueryParameter(tenantId));
            }
            if (withExpand) {
                queryParameters.add(HanaTenant.getExpandContainersAndCredentials());
            }
            if (StringUtils.isNotBlank((CharSequence)skipToken)) {
                queryParameters.add(new QueryParameter(SKIPTOKEN, skipToken));
            }
            ServiceCall getHanaTenants = this.hanaTenantsEndpoint.createServiceCall().http().get().withoutPayload().noPathParameter().query(queryParameters).end();
            Instant startTime = Instant.now();
            ServiceResponse response = getHanaTenants.execute(Map.class);
            logger.debug("Determination of HANA tenants for BTP tenant {} took {} ms, expand active={}", new Object[]{tenantId, Duration.between(startTime, Instant.now()).toMillis(), withExpand});
            Map payload = response.getPayload().orElse(new HashMap());
            skipToken = (String)payload.get(SKIPTOKEN);
            List<HanaTenant> hanaTenants = HanaTenant.getTenantsFromPayload(payload);
            if (StringUtils.isNotBlank((CharSequence)skipToken)) {
                hanaTenants.addAll(this.readHanaTenants(skipToken, null, withExpand));
            }
            logger.debug("The number of found Hana tenants is {}", (Object)hanaTenants.size());
            return hanaTenants;
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private ContainersWithEtag readContainers(String hanaTenantId, boolean withExpand) throws InternalError {
        try {
            ArrayList<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
            if (withExpand) {
                queryParameters.add(Container.getExpandCredentials());
            }
            ServiceCall getContainers = this.containersEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(new String[]{hanaTenantId}).query(queryParameters).end();
            Instant startTime = Instant.now();
            ServiceResponse response = getContainers.execute(Map.class);
            logger.debug("Determination of HDI containers for HANA tenant {} took {} ms, expand active={}", new Object[]{hanaTenantId, Duration.between(startTime, Instant.now()).toMillis(), withExpand});
            Map payload = response.getPayload().orElse(new HashMap());
            String etag = (String)response.getETag().orElseThrow(() -> new InternalError(NO_ETAG_RETURNED));
            if (etag.isBlank()) {
                throw new InternalError(NO_ETAG_RETURNED);
            }
            List<Container> containers = Container.getContainersFromPayload(payload);
            return new ContainersWithEtag(containers, etag);
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private CredentialsWithEtag readCredentials(String hanaTenantId, String containerId) throws InternalError {
        try {
            ServiceCall getCredentials = this.credentialsEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(new String[]{hanaTenantId, containerId}).noQuery().end();
            Instant startTime = Instant.now();
            ServiceResponse response = getCredentials.execute(Map.class);
            logger.debug("Determination of credentials for HANA tenant {} and container id={}, took {}ms", new Object[]{hanaTenantId, containerId, Duration.between(startTime, Instant.now()).toMillis()});
            Map payload = response.getPayload().orElse(new HashMap());
            String etag = (String)response.getETag().orElseThrow(() -> new InternalError(NO_ETAG_RETURNED));
            if (etag.isBlank()) {
                throw new InternalError(NO_ETAG_RETURNED);
            }
            return new CredentialsWithEtag(Credential.getCredentialsFromPayload(payload), etag);
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private void deleteCredential(String hanaTenantId, String containerId, String credentialId) throws InternalError {
        try {
            ServiceCall deleteCredential = this.credentialEndpoint.createServiceCall().http().delete().withoutPayload().pathParameter(new String[]{hanaTenantId, containerId, credentialId}).noQuery().end();
            Instant startTime = Instant.now();
            deleteCredential.execute(Map.class);
            logger.debug("Deletion of credentials with id {} took {}ms", (Object)containerId, (Object)Duration.between(startTime, Instant.now()).toMillis());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private void deleteContainer(String hanaTenantId, String containerId) throws InternalError {
        try {
            ServiceCall deleteContainer = this.containerEndpoint.createServiceCall().http().delete().withoutPayload().pathParameter(new String[]{hanaTenantId, containerId}).noQuery().end();
            Instant startTime = Instant.now();
            deleteContainer.execute(Map.class);
            logger.debug("Deletion of container with id {} took {}ms", (Object)containerId, (Object)Duration.between(startTime, Instant.now()).toMillis());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private Optional<HanaTenant> readHanaTenant(String hanaTenantId, boolean withExpand) throws InternalError {
        try {
            ArrayList<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
            if (withExpand) {
                queryParameters.add(HanaTenant.getExpandContainersAndCredentials());
            }
            ServiceCall getHanaTenant = this.hanaTenantsEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(new String[]{hanaTenantId}).query(queryParameters).end();
            ServiceResponse response = getHanaTenant.execute(Map.class);
            return Optional.of(new HanaTenant(response.getPayload().orElse(new HashMap())));
        }
        catch (InternalException | ServiceException e) {
            logger.error("Could read HANA tenant %s".formatted(hanaTenantId), e);
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private HttpDestination getDestination(ServiceBinding binding, Duration oauthTimeout) throws InternalError {
        logger.debug("Create destination for Hana Mt service");
        if (StringUtils.isBlank((CharSequence)((String)binding.getCredentials().get(BASEURL)))) {
            throw new InternalError("Hana Multitenancy Service url is missing");
        }
        logger.debug("Hana API url is {}", binding.getCredentials().get(BASEURL));
        if (binding.getName().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)binding.getName().get()))) {
            throw new InternalError("Service binding name is missing");
        }
        logger.debug("Hana API binding name is {}", binding.getName().get());
        if (binding.getServiceName().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)binding.getServiceName().get()))) {
            throw new InternalError("Service name is missing");
        }
        ResilienceConfiguration.TimeLimiterConfiguration timeLimiterConfiguration = ResilienceConfiguration.TimeLimiterConfiguration.of((Duration)(oauthTimeout != null ? oauthTimeout : Duration.ofSeconds(30L)));
        HttpDestination destination = ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).withOption((ServiceBindingDestinationOptions.OptionsEnhancer)OAuth2Options.TokenRetrievalTimeout.of((ResilienceConfiguration.TimeLimiterConfiguration)timeLimiterConfiguration)).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build());
        logger.debug("Hana Mt destination uri is {}", (Object)destination.getUri());
        return destination;
    }

    private void checkThatContainersWereDeleted(HanaTenant hanaTenant) throws InternalError {
        Wrap containersSizeWrap = Wrap.wrapEmpty(Integer.class);
        this.serviceSpecification.getPolling().pollUntil(first -> {
            try {
                List<Container> containers = this.readContainers(hanaTenant.getId(), false).containers();
                containersSizeWrap.set((Object)containers.size());
                return containers.isEmpty();
            }
            catch (InternalError e) {
                logger.error("An exception occurred during container deletion", (Throwable)e);
                return true;
            }
        });
        if (containersSizeWrap.isEmpty() || (Integer)containersSizeWrap.get() != 0) {
            throw new InternalError("Not all HDI containers could be deleted");
        }
    }

    private InternalError serviceErrorHandling(Exception e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof InternalError) {
            InternalError internalError = (InternalError)throwable;
            return internalError;
        }
        return new InternalError(e);
    }

    private void checkTenantId(String tenantId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError("Tenant id is blank or empty");
        }
    }

    private Optional<HanaTenant> getOneHanaTenantViaBtpTenantId(String tenantId) throws InternalError {
        logger.debug("Read one HANA tenants via BTP tenant id {}", (Object)tenantId);
        List<HanaTenant> tenants = this.readHanaTenants(null, tenantId, true);
        if (tenants.isEmpty()) {
            return Optional.empty();
        }
        if (tenants.size() != 1) {
            throw new InternalError("Multiple HANA tenants found for BTP tenant id %s".formatted(tenantId));
        }
        logger.debug("HANA tenant {} was found for BTP tenant {}", (Object)tenants.get(0).getId(), (Object)tenantId);
        return Optional.of(tenants.get(0));
    }

    private String createHanaTenant(String tenantId, ProvisioningParameters provisioningParameters) throws InternalError {
        HanaTenantIdAndPrefixAndName hanaTenantIdRecord = this.createHanaTenantId((String)provisioningParameters.get(HANA_TENANT_ID_IN_PROVISIONING), this.hanaTenantPrefix, tenantId);
        logger.debug("Create a new HANA tenant {} for BTP tenant id {}", (Object)hanaTenantIdRecord.hanaTenantId(), (Object)tenantId);
        try {
            Map<String, Object> payload = HanaTenant.createCreatePayload(tenantId, provisioningParameters, hanaTenantIdRecord.prefix(), hanaTenantIdRecord.name());
            ServiceCall createHanaTenant = this.hanaTenantsEndpoint.createServiceCall().http().put().payload(payload).pathParameter(new String[]{hanaTenantIdRecord.hanaTenantId()}).query(null).end();
            Instant startTime = Instant.now();
            ServiceResponse response = createHanaTenant.execute(Void.class);
            logger.debug("Creation of HANA tenant for BTP tenant {} took {}ms", (Object)tenantId, (Object)Duration.between(startTime, Instant.now()).toMillis());
            Optional<String> locationOpt = Arrays.stream(response.getHeaders()).filter(h -> h.getName().equalsIgnoreCase(LOCATION)).map(NameValuePair::getValue).findFirst();
            if (locationOpt.isEmpty() || !locationOpt.get().contains("/tenants/v2/tenants/")) {
                throw new InternalError("No location returned");
            }
            return hanaTenantIdRecord.hanaTenantId();
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private HanaTenantIdAndPrefixAndName createHanaTenantId(String externalHanaTenantId, String prefix, String tenantId) throws InternalError {
        if (StringUtils.isNotBlank((CharSequence)externalHanaTenantId)) {
            HanaMtService.checkUuid(externalHanaTenantId);
            return new HanaTenantIdAndPrefixAndName(externalHanaTenantId, "", "");
        }
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            return new HanaTenantIdAndPrefixAndName(this.hashGuidFromString("%s-%s".formatted(prefix, tenantId)), prefix, tenantId);
        }
        throw new InternalError("Neither prefix nor explicit Hana tenant id specified");
    }

    private static void checkUuid(Object uuid) throws InternalError {
        try {
            UUID.fromString((String)uuid);
        }
        catch (IllegalArgumentException e) {
            throw new InternalError("Value %s is not an UUID".formatted(uuid));
        }
    }

    private ContainerIdWithResponseCode createContainer(String hanaTenantId, String tenantId, String etag) throws InternalError {
        Map<String, Object> payload = Container.createCreatePayload(tenantId);
        try {
            ServiceCall createContainer = this.containersEndpoint.createServiceCall().http().post().payload(payload).pathParameter(new String[]{hanaTenantId}).query(null).insertHeaderFields(Collections.singletonMap(IF_MATCH, etag)).end();
            Instant startTime = Instant.now();
            ServiceResponse response = createContainer.execute(Void.class);
            logger.debug("Creation of HDI container for BTP tenant {} took {}ms", (Object)tenantId, (Object)Duration.between(startTime, Instant.now()).toMillis());
            Optional<String> locationOpt = Arrays.stream(response.getHeaders()).filter(h -> h.getName().equalsIgnoreCase(LOCATION)).map(NameValuePair::getValue).findFirst();
            String containerPath = CONTAINERS_ENDPOINT.formatted(hanaTenantId) + "/";
            if (locationOpt.isEmpty() || !locationOpt.get().contains(containerPath)) {
                throw new InternalError("No location returned");
            }
            String[] parts = locationOpt.get().split(containerPath);
            if (parts.length < 2 || parts[1].isEmpty()) {
                throw new InternalError("Container id is missing in the location");
            }
            return new ContainerIdWithResponseCode(parts[1], response.getHttpStatusCode());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private CredentialIdWithResponseCode createCredential(String hanaTenantId, String containerId, String etag) throws InternalError {
        Map<String, Object> payload = Credential.createCreatePayload();
        try {
            ServiceCall createCredential = this.credentialsEndpoint.createServiceCall().http().post().payload(payload).pathParameter(new String[]{hanaTenantId, containerId}).noQuery().insertHeaderFields(Collections.singletonMap(IF_MATCH, etag)).end();
            Instant startTime = Instant.now();
            ServiceResponse response = createCredential.execute(Void.class);
            logger.debug("Creation of credentials for container with id {} took {}ms", (Object)containerId, (Object)Duration.between(startTime, Instant.now()).toMillis());
            Optional<String> locationOpt = Arrays.stream(response.getHeaders()).filter(h -> h.getName().equalsIgnoreCase(LOCATION)).map(NameValuePair::getValue).findFirst();
            String credentialPath = CREDENTIALS_ENDPOINT.formatted(hanaTenantId, containerId) + "/";
            if (locationOpt.isEmpty() || !locationOpt.get().contains(credentialPath)) {
                throw new InternalError("No location returned");
            }
            String[] parts = locationOpt.get().split(credentialPath);
            if (parts.length < 2 || parts[1].isEmpty()) {
                throw new InternalError("Credential id is missing in the location");
            }
            return new CredentialIdWithResponseCode(parts[1], response.getHttpStatusCode());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private String hashGuidFromString(String input) throws InternalError {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(input.getBytes("UTF-8"));
            ByteBuffer bb = ByteBuffer.wrap(hash);
            long mostSigBits = bb.getLong();
            long leastSigBits = bb.getLong();
            return new UUID(mostSigBits, leastSigBits).toString();
        }
        catch (Exception e) {
            throw new InternalError("Could not create a guid");
        }
    }

    static {
        HanaMtPropertySupplier.initialize();
    }

    private record HanaTenantIdAndPrefixAndName(String hanaTenantId, String prefix, String name) {
    }
}

