/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription.hana.mt.service;

import com.sap.cds.feature.mt.lib.subscription.ProvisioningParameters;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Container;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Status;
import com.sap.cds.feature.mt.lib.subscription.hana.mt.service.Tools;
import com.sap.cds.services.utils.lib.tools.api.QueryParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HanaTenant
extends HashMap<String, Object> {
    private static final String LABELS_NODE = "labels";
    private static final String TENANT_ID = "tenant_id";
    private static final String STATUS_NODE = "status";
    private static final String ID_NODE = "id";
    private static final String CONTAINERS_NODE = "containers";
    private static final String DATA_ENCRYPTION_NODE = "dataEncryption";
    private static final String MODE_NODE = "mode";
    private static final String TENANT_ID_TEMPLATE = "tenant_id=%s";
    private static final String PREFIX_TEMPLATE = "prefix=%s";
    private static final String NAME_TEMPLATE = "name=%s";
    private static final String CONTAINER_FILTER_PARAMETER = "containerFilter";
    private static final String BTP_TENANT_LABEL_QUERY = "hassubset(labels, [\"tenant_id=%s\"])";
    private static final String EXPAND_PARAMETER = "$expand";
    private static final String EXPAND_CONTAINERS_AND_CREDENTIALS = "containers/credentials";
    private static final String DATA_NODE = "data";
    public static final String SERVICE_INSTANCE_ID_NODE = "serviceInstanceID";
    private final List<Container> containers = new ArrayList<Container>();

    public HanaTenant(Map<String, ?> m) {
        super(m);
        if (this.containsKey(CONTAINERS_NODE)) {
            Tools.asListMap(this.get(CONTAINERS_NODE)).stream().forEach((? super T containerData) -> this.containers.add(new Container((Map<String, ?>)containerData)));
        }
    }

    public static Map<String, Object> createCreatePayload(String tenantId, ProvisioningParameters provisioningParameters, String prefix, String name) {
        String prefixLabel;
        String mode;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(SERVICE_INSTANCE_ID_NODE, provisioningParameters.getDatabaseId());
        Map dataEncryption = (Map)provisioningParameters.get(DATA_ENCRYPTION_NODE);
        if (dataEncryption != null && (mode = (String)dataEncryption.get(MODE_NODE)) != null) {
            HashMap<String, String> dataEncryptionPayload = new HashMap<String, String>();
            dataEncryptionPayload.put(MODE_NODE, mode);
            payload.put(DATA_ENCRYPTION_NODE, dataEncryptionPayload);
        }
        prefixLabel = (prefixLabel = PREFIX_TEMPLATE.formatted(prefix)).length() > 64 ? prefixLabel.substring(0, 64) : prefixLabel;
        String nameLabel = NAME_TEMPLATE.formatted(name);
        nameLabel = nameLabel.length() > 64 ? nameLabel.substring(0, 64) : nameLabel;
        List<String> labels = List.of(prefixLabel, nameLabel);
        payload.put(LABELS_NODE, labels);
        return payload;
    }

    public static QueryParameter getContainerQueryParameter(String tenantId) {
        return new QueryParameter(CONTAINER_FILTER_PARAMETER, BTP_TENANT_LABEL_QUERY.formatted(tenantId));
    }

    public static QueryParameter getExpandContainersAndCredentials() {
        return new QueryParameter(EXPAND_PARAMETER, EXPAND_CONTAINERS_AND_CREDENTIALS);
    }

    public static List<HanaTenant> getTenantsFromPayload(Map<String, Object> payload) {
        ArrayList<HanaTenant> hanaTenants = new ArrayList<HanaTenant>();
        if (payload.containsKey(DATA_NODE)) {
            Tools.asListMap(payload.get(DATA_NODE)).forEach((? super T tenantData) -> hanaTenants.add(new HanaTenant((Map<String, ?>)tenantData)));
        }
        return hanaTenants;
    }

    public String getDatabaseId() {
        String dataBaseId = (String)this.get(SERVICE_INSTANCE_ID_NODE);
        if (StringUtils.isBlank((CharSequence)dataBaseId)) {
            return "";
        }
        return dataBaseId;
    }

    public Status getStatus() {
        return new Status(Tools.asMap(this.get(STATUS_NODE)));
    }

    public String getId() {
        if (!this.containsKey(ID_NODE)) {
            return "";
        }
        return (String)this.get(ID_NODE);
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HanaTenant that = (HanaTenant)o;
        return Objects.equals(this.containers, that.containers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.containers);
    }
}

