/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.feature.mt.lib.subscription.UiUrlCreator;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.AppUiUrlEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;

@ServiceName(value={"DeploymentService$Default"})
public class AppUiUrlEventHandler
implements EventHandler {
    private static final String FALLBACK_APP_URL = "tenant successfully subscribed - no application URL provided";
    private final CdsProperties.MultiTenancy.AppUi appUi;

    public AppUiUrlEventHandler(CdsRuntime runtime) {
        CdsProperties.MultiTenancy config = runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        this.appUi = config.getAppUi();
    }

    @On
    @HandlerOrder(value=11000)
    protected String onAppUiUrl(AppUiUrlEventContext context) {
        try {
            String configuredUrl = UiUrlCreator.createUrl(context.getSubdomain(), this.appUi.getUrl(), this.appUi.getTenantSeparator());
            return StringUtils.isEmpty((String)configuredUrl) ? FALLBACK_APP_URL : configuredUrl;
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.CREATE_APP_UI_URL_FAILED, new Object[]{e});
        }
    }
}

