/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.DependenciesEventContext;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"DeploymentService$Default"})
public class SubscriptionDependencyMtHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionDependencyMtHandler.class);
    public static final String PORTAL = "portal";
    public static final String HTML5_APPS_REPO = "html5-apps-repo";
    private static final String XSAPPNAME_FIELD = "xsappname";
    private String xsappname;
    private String bindingName;

    public SubscriptionDependencyMtHandler(Stream<ServiceBinding> bindings, String serviceName) {
        Optional<ServiceBinding> binding = bindings.filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)serviceName)).findFirst();
        if (binding.isPresent()) {
            Map uaa;
            this.bindingName = binding.get().getName().orElse("");
            Map credentials = binding.get().getCredentials();
            Object v = credentials.get("uaa");
            if (v instanceof Map && (uaa = (Map)v).containsKey(XSAPPNAME_FIELD)) {
                this.xsappname = (String)uaa.get(XSAPPNAME_FIELD);
            }
        }
    }

    @After
    public void addDestinationDependency(DependenciesEventContext context) {
        if (this.xsappname == null) {
            return;
        }
        logger.debug("Providing subscription dependency for binding '{}' with xsappname '{}'", (Object)this.bindingName, (Object)this.xsappname);
        context.getResult().add(Collections.singletonMap(XSAPPNAME_FIELD, this.xsappname));
    }
}

