/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ord.adapter;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.feature.ord.provider.OrdProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.path.UrlPathUtil;
import java.io.PrintWriter;

public class OrdIndexContentProvider
implements IndexContentProvider {
    private static final String SECTION = "                <h3 class=\"header\">\n                    <a href=\"%s/\"><span>%s</span></a>\n                </h3>\n";
    private static final String DOCUMENT_START = "                <ul>\n";
    private static final String DOCUMENT = "                    <li>\n                        <div><a href=\"%s\"><span>%s</span></a></div>\n                    </li>\n";
    private static final String DOCUMENT_END = "                </ul>\n";
    private final CdsRuntime runtime;

    OrdIndexContentProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public String getSectionTitle() {
        return "Open Resource Discovery endpoints";
    }

    public void writeContent(PrintWriter out, String contextPath) {
        String basePath = UrlPathUtil.normalizeBasePath((String)this.runtime.getEnvironment().getCdsProperties().getOrd().getEndpoint().getPath());
        OrdProvider provider = (OrdProvider)this.runtime.getProvider(OrdProvider.class);
        String documentPath = "/documents/" + provider.getDocumentPath();
        out.format(SECTION, basePath, basePath);
        out.format(DOCUMENT_START, new Object[0]);
        out.format(DOCUMENT, basePath + documentPath, documentPath);
        out.format(DOCUMENT_END, new Object[0]);
    }
}

