/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ord.adapter;

import com.sap.cds.adapter.edmx.EdmxV4Provider;
import com.sap.cds.feature.ord.adapter.OrdDocument;
import com.sap.cds.feature.ord.provider.OrdProvider;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.cert.CertValidator;
import com.sap.cds.services.utils.cert.UclAuthUtils;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(OrdServlet.class);
    private final CdsRuntime runtime;
    private final CertValidator certValidator;

    public OrdServlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.certValidator = UclAuthUtils.createCertValidator((CdsRuntime)runtime);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        logger.debug("Received request for Open Resource Discovery (ORD)");
        try {
            boolean authenticateMetadataEndpoints = this.runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().isAuthenticateMetadataEndpoints();
            if (authenticateMetadataEndpoints) {
                UclAuthUtils.checkAuthorization((CertValidator)this.certValidator, (CdsRuntime)this.runtime);
            }
        }
        catch (ServiceException e) {
            OrdServlet.handleException(res, null, e);
            return;
        }
        catch (Throwable t) {
            logger.error("Unexpected error", t);
            res.setStatus(500);
            return;
        }
        this.runtime.requestContext().systemUserProvider().run(requestContext -> {
            try {
                String p = req.getPathInfo();
                if (p.isEmpty() || p.equals("/")) {
                    this.processOrdIndexDocument(res);
                } else if (p.endsWith("edmx")) {
                    this.processEdmxDocument(req, res);
                } else if (p.startsWith("/documents")) {
                    this.processOrdDocument(res);
                } else {
                    res.setStatus(404);
                }
            }
            catch (ServiceException e) {
                OrdServlet.handleException(res, requestContext.getParameterInfo().getLocale(), e);
            }
            catch (Throwable t) {
                logger.error("Unexpected error", t);
                res.setStatus(500);
            }
        });
    }

    private void processOrdIndexDocument(HttpServletResponse res) throws IOException {
        ArrayList<OrdDocument> documents = new ArrayList<OrdDocument>();
        OrdProvider provider = (OrdProvider)this.runtime.getProvider(OrdProvider.class);
        String path = provider.getDocumentPath();
        UclAuthUtils.AccessStrategy strategy = UclAuthUtils.AccessStrategy.fromConfig((CdsRuntime)this.runtime);
        if (path != null) {
            logger.debug("Adding ORD document from {} to index document", (Object)path);
            String ordEndpointPath = this.runtime.getEnvironment().getCdsProperties().getOrd().getEndpoint().getPath();
            documents.add(OrdDocument.of(Map.of("url", ordEndpointPath + "/documents/" + path, "accessStrategies", List.of(Map.of("type", strategy.getValue())))));
        }
        provider.getAdditionalDocumentLinks().forEach((name, uri) -> {
            logger.debug("Adding external ORD document {} to index document", name);
            documents.add(OrdDocument.of(Map.of("url", uri.toString(), "accessStrategies", List.of(Map.of("type", strategy.getValue())))));
        });
        res.setStatus(200);
        OrdServlet.setContentType(res, ContentType.APPLICATION_JSON);
        HashMap response = new HashMap();
        response.put("openResourceDiscoveryV1", Map.of("documents", documents));
        Jsonizer.write((Writer)res.getWriter(), response);
    }

    private void processEdmxDocument(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String[] pathSegments = req.getPathInfo().split("/");
        if (pathSegments.length != 4) {
            res.setStatus(404);
            return;
        }
        String serviceName = pathSegments[3].split("\\.")[0];
        EdmxV4Provider edmxProvider = (EdmxV4Provider)this.runtime.getProvider(EdmxV4Provider.class);
        try (InputStream edmxInputStream = edmxProvider.getEdmx(serviceName);){
            if (edmxInputStream != null) {
                res.setStatus(200);
                OrdServlet.setContentType(res, ContentType.APPLICATION_XML);
                edmxInputStream.transferTo((OutputStream)res.getOutputStream());
            } else {
                res.setStatus(404);
            }
        }
    }

    private void processOrdDocument(HttpServletResponse res) throws IOException {
        OrdProvider provider = (OrdProvider)this.runtime.getProvider(OrdProvider.class);
        try (InputStream documentStream = provider.getDocument();){
            if (documentStream != null) {
                res.setStatus(200);
                OrdServlet.setContentType(res, ContentType.APPLICATION_JSON);
                documentStream.transferTo((OutputStream)res.getOutputStream());
            } else {
                res.setStatus(404);
            }
        }
    }

    private static void setContentType(HttpServletResponse resp, ContentType contType) {
        resp.setContentType(contType.getMimeType());
        resp.setCharacterEncoding(contType.getCharset().toString());
    }

    private static void handleException(HttpServletResponse res, Locale locale, ServiceException e) {
        block10: {
            if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                logger.error("Unexpected error", (Throwable)e);
            } else {
                logger.debug("Service exception thrown", (Throwable)e);
            }
            res.setStatus(e.getErrorStatus().getHttpStatus());
            try {
                String message = e.getLocalizedMessage(locale);
                if (message == null) break block10;
                try (PrintWriter writer = res.getWriter();){
                    writer.write(message);
                }
            }
            catch (IOException e1) {
                logger.error("Failed to write error message to response", (Throwable)e1);
            }
        }
    }
}

