/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ord.processor;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.sap.cds.feature.ord.processor.CdsOrdNodeProcessor;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class EntryPointsProcessor
implements CdsOrdNodeProcessor {
    private CdsRuntime runtime;

    @Override
    public Predicate<String> predicate() {
        return "entryPoints"::equals;
    }

    @Override
    public <T extends TreeNode> Optional<T> process(@Nullable String nodeName, @Nullable T node) {
        if (node == null) {
            return Optional.empty();
        }
        ArrayNode newNode = JsonNodeFactory.instance.arrayNode();
        ((ArrayNode)node).forEach(n -> {
            String path = this.runtime.getEnvironment().getCdsProperties().getOdataV4().getEndpoint().getPath();
            String newPath = n.asText().replace("/odata/v4", path);
            newNode.add((JsonNode)JsonNodeFactory.instance.textNode(newPath));
        });
        return Optional.ofNullable(newNode);
    }

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }
}

