/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ord.processor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.primitives.Bytes;
import com.sap.cds.feature.ord.processor.CdsOrdNodeProcessor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OrdJsonInputStream
extends InputStream {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES}).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private final InputStream inputStream;
    private final List<CdsOrdNodeProcessor> nodeProcessors;
    private final JsonParser parser;
    private JsonToken token;
    private JsonToken previousToken;
    private final List<Byte> buffer = new ArrayList<Byte>();

    public OrdJsonInputStream(InputStream inputStream, List<CdsOrdNodeProcessor> nodeProcessors) throws IOException {
        this.inputStream = new BufferedInputStream(inputStream);
        this.nodeProcessors = nodeProcessors;
        this.parser = MAPPER.getFactory().createParser(inputStream);
        this.token = this.parser.nextToken();
        this.previousToken = null;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        this.inputStream.close();
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.isEmpty()) {
            return this.buffer.remove(0) & 0xFF;
        }
        if (this.parser.isClosed()) {
            return -1;
        }
        if (this.token == null) {
            return -1;
        }
        JsonToken previewToken = null;
        if (this.token.isStructStart()) {
            if (this.previousToken != null && this.previousToken.isStructEnd()) {
                this.appendToBuffer(",");
            }
            this.appendToBuffer(this.token.asString());
        } else if (this.token.isStructEnd()) {
            previewToken = this.parser.nextToken();
            if (previewToken == null) {
                List<CdsOrdNodeProcessor> generators = this.nodeProcessors.stream().filter(CdsOrdNodeProcessor::canGenerate).toList();
                if (generators.isEmpty()) {
                    this.appendToBuffer(this.token.asString());
                    return this.buffer.remove(0) & 0xFF;
                }
                generators.forEach(processor -> {
                    Optional<Object> processedNode = processor.process(null, null);
                    processedNode.ifPresent(jsonNode -> {
                        this.appendToBuffer(", \"" + processor.getGeneratedNodeName() + "\": ");
                        this.appendToBuffer(jsonNode.toPrettyString());
                    });
                });
            }
            this.appendToBuffer(this.token.asString());
        } else if (this.token == JsonToken.FIELD_NAME) {
            if (!this.previousToken.isStructStart()) {
                this.appendToBuffer(",");
            }
            String currentName = this.parser.currentName();
            this.appendToBuffer("\"");
            this.appendToBuffer(currentName);
            this.appendToBuffer("\": ");
            List<CdsOrdNodeProcessor> processors = this.nodeProcessors.stream().filter(processor -> processor.predicate().test(currentName)).toList();
            if (!processors.isEmpty()) {
                this.parser.nextToken();
                JsonNode node = (JsonNode)this.parser.readValueAsTree();
                JsonNode processedNode = processors.stream().reduce(node, (currentNode, processor) -> processor.process(currentName, currentNode).orElse((JsonNode)currentNode), (node1, node2) -> node1);
                this.appendToBuffer(processedNode.toPrettyString());
            }
        } else if (this.token == JsonToken.VALUE_STRING) {
            this.appendToBuffer("\"");
            this.appendToBuffer(this.parser.getValueAsString());
            this.appendToBuffer("\"");
        } else if (this.token.isScalarValue()) {
            this.appendToBuffer(this.token.asString());
        }
        this.previousToken = this.token;
        this.token = previewToken != null ? previewToken : this.parser.nextToken();
        return this.buffer.remove(0) & 0xFF;
    }

    private void appendToBuffer(String value) {
        this.buffer.addAll(Bytes.asList((byte[])value.getBytes(StandardCharsets.UTF_8)));
    }
}

