/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ord.processor;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.feature.ord.processor.CdsOrdNodeProcessor;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.cert.UclAuthUtils;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class ResourceDefinitionsProcessor
implements CdsOrdNodeProcessor {
    private CdsRuntime runtime;

    @Override
    public Predicate<String> predicate() {
        return "resourceDefinitions"::equals;
    }

    @Override
    public <T extends TreeNode> Optional<T> process(@Nullable String nodeName, @Nullable T resourceDefinitions) {
        if (resourceDefinitions instanceof ArrayNode) {
            ArrayNode newResourceDefinitions = JsonNodeFactory.instance.arrayNode();
            ((ArrayNode)resourceDefinitions).forEach(resourceDefinition -> {
                if (resourceDefinition.get("type").textValue().equals("edmx")) {
                    newResourceDefinitions.add(resourceDefinition);
                    ArrayNode accessStrategies = JsonNodeFactory.instance.arrayNode();
                    ObjectNode accessStrategy = JsonNodeFactory.instance.objectNode();
                    accessStrategy.put("type", UclAuthUtils.AccessStrategy.fromConfig((CdsRuntime)this.runtime).getValue());
                    accessStrategies.add((JsonNode)accessStrategy);
                    ((ObjectNode)resourceDefinition).set("accessStrategies", (JsonNode)accessStrategies);
                }
            });
            return Optional.ofNullable(newResourceDefinitions);
        }
        throw new ServiceException("Expected 'resourceDefinitions' to be an array.", new Object[0]);
    }

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }
}

