/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ord.provider;

import com.sap.cds.feature.ord.provider.OrdProvider;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalLinkOrdProvider
implements OrdProvider {
    private Logger logger = LoggerFactory.getLogger(ExternalLinkOrdProvider.class);
    private OrdProvider previous;
    private final CdsRuntime runtime;

    public ExternalLinkOrdProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public InputStream getDocument() {
        return this.previous.getDocument();
    }

    @Override
    public String getDocumentPath() {
        return this.previous.getDocumentPath();
    }

    @Override
    public Map<String, URI> getAdditionalDocumentLinks() {
        return this.runtime.getEnvironment().getCdsProperties().getOrd().getOrdLinks().stream().filter(link -> {
            try {
                new URL(link.getLink());
            }
            catch (MalformedURLException e) {
                this.logger.warn("Malformed URL for external ORD document link '{}' is skipped.", (Object)link.getName());
                return false;
            }
            return true;
        }).collect(Collectors.toMap(CdsProperties.OpenResourceDiscovery.ORDLink::getName, link -> URI.create(link.getLink())));
    }

    public void setPrevious(OrdProvider previous) {
        this.previous = previous;
    }
}

