/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ord.provider;

import com.sap.cds.feature.ord.processor.CdsOrdNodeProcessor;
import com.sap.cds.feature.ord.processor.OrdJsonInputStream;
import com.sap.cds.feature.ord.provider.OrdProvider;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.utils.CdsErrorStatuses;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticOrdProvider
implements OrdProvider {
    private final Logger logger = LoggerFactory.getLogger(StaticOrdProvider.class);
    private final CdsRuntime runtime;
    private final List<CdsOrdNodeProcessor> nodeProcessors = new ArrayList<CdsOrdNodeProcessor>();

    public StaticOrdProvider(CdsRuntime runtime) {
        this.runtime = runtime;
        ExtendedServiceLoader.loadAll(CdsOrdNodeProcessor.class, (CdsRuntime)this.runtime).forEachRemaining(this::nodeProcessor);
    }

    private void nodeProcessor(CdsOrdNodeProcessor ordNodeProcessor) {
        ordNodeProcessor.setCdsRuntime(this.runtime);
        this.nodeProcessors.add(ordNodeProcessor);
    }

    @Override
    public InputStream getDocument() {
        String ordPath = this.getDocumentPath();
        if (ordPath != null) {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            this.logger.debug("Creating ORD document from {}", (Object)ordPath);
            try {
                return new OrdJsonInputStream(classloader.getResourceAsStream(ordPath), this.nodeProcessors);
            }
            catch (IOException e) {
                throw new ServiceException((ErrorStatus)CdsErrorStatuses.ERROR_READING_ORD_DOCUMENT, ordPath, new Object[]{e});
            }
        }
        return null;
    }

    @Override
    public String getDocumentPath() {
        String ordPath = this.runtime.getEnvironment().getCdsProperties().getOrd().getOrdPath();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        return classloader.getResource(ordPath) != null ? ordPath : null;
    }
}

