/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.postgresql;

import com.sap.cds.feature.postgresql.PostgreSqlSSLFactory;
import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlDataSourceDescriptor
implements DataSourceDescriptor {
    private static final Logger log = LoggerFactory.getLogger(PostgreSqlDataSourceDescriptor.class);
    private final String name;
    private final String url;
    private final String username;
    private final String password;

    public PostgreSqlDataSourceDescriptor(ServiceBinding binding) {
        this.name = (String)binding.getName().get();
        Map credentials = binding.getCredentials();
        String jdbcUrl = PostgreSqlDataSourceDescriptor.createJdbcUrl(credentials);
        this.url = this.enableSsl(jdbcUrl, credentials);
        this.username = PostgreSqlDataSourceDescriptor.getUser(credentials);
        this.password = (String)credentials.get("password");
    }

    public String getName() {
        return this.name;
    }

    public String getDriverClassName() {
        return Driver.class.getName();
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private String enableSsl(String jdbcUrl, Map<String, Object> credentials) {
        String sslRootCert = PostgreSqlDataSourceDescriptor.getCaCert(credentials);
        if (!StringUtils.isEmpty((String)sslRootCert)) {
            Base64.Encoder encoder = Base64.getUrlEncoder();
            String sslVerificationMode = credentials.containsKey("sslkey") ? "verify-ca" : "verify-full";
            jdbcUrl = (String)jdbcUrl + "?sslmode=%s&sslfactory=%s&sslrootcertbase64=%s".formatted(sslVerificationMode, PostgreSqlSSLFactory.class.getName(), encoder.encodeToString(sslRootCert.getBytes(StandardCharsets.UTF_8)));
            log.debug("Enabled SSL certificate and hostname verification for PostgreSQL binding '{}'", (Object)this.name);
            String sslClientCert = PostgreSqlDataSourceDescriptor.getClientCert(credentials);
            String sslPrivateKey = PostgreSqlDataSourceDescriptor.getPrivateKey(credentials);
            if (!StringUtils.isEmpty((String)sslClientCert) && !StringUtils.isEmpty((String)sslPrivateKey)) {
                jdbcUrl = (String)jdbcUrl + "&sslclientcertbase64=%s&sslprivatekeybase64=%s".formatted(encoder.encodeToString(sslClientCert.getBytes(StandardCharsets.UTF_8)), encoder.encodeToString(sslPrivateKey.getBytes(StandardCharsets.UTF_8)));
                log.debug("Enabled mTLS for PostgreSQL binding '{}'", (Object)this.name);
            }
        } else {
            log.debug("PostgreSQL binding '{}' is missing the CA certificate.", (Object)this.name);
        }
        return jdbcUrl;
    }

    private static String createJdbcUrl(Map<String, Object> credentials) {
        Object port;
        String host = (String)credentials.get("hostname");
        if (StringUtils.isEmpty((String)host)) {
            host = (String)credentials.get("host");
        }
        port = (port = credentials.get("port")) != null ? port.toString() : "5432";
        String dbName = (String)credentials.get("dbname");
        if (StringUtils.isEmpty((String)dbName)) {
            dbName = (String)credentials.get("database");
        }
        return "jdbc:postgresql://%s:%s/%s".formatted(host, port, dbName);
    }

    private static String getCaCert(Map<String, Object> credentials) {
        return (String)credentials.get("sslrootcert");
    }

    private static String getClientCert(Map<String, Object> credentials) {
        return (String)credentials.get("sslcert");
    }

    private static String getPrivateKey(Map<String, Object> credentials) {
        return (String)credentials.get("sslkey");
    }

    private static String getUser(Map<String, Object> credentials) {
        String user = (String)credentials.get("username");
        if (StringUtils.isEmpty((String)user)) {
            user = (String)credentials.get("user");
        }
        return user;
    }
}

