/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.postgresql;

import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.postgresql.ssl.WrappedFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlSSLFactory
extends WrappedFactory {
    private static final Logger log = LoggerFactory.getLogger(PostgreSqlSSLFactory.class);

    public PostgreSqlSSLFactory(Properties props) {
        String rootCertBase64 = props.getProperty("sslrootcertbase64");
        String privateKeyBase64 = props.getProperty("sslprivatekeybase64");
        String clientCertBase64 = props.getProperty("sslclientcertbase64");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null);
            KeyManager[] keyManagers = null;
            if (!StringUtils.isEmpty((String)privateKeyBase64)) {
                String sslPrivateKey = new String(decoder.decode(privateKeyBase64), StandardCharsets.UTF_8);
                PrivateKey privateKey = PostgreSqlSSLFactory.generatePrivateKey(sslPrivateKey);
                Certificate clientCert = PostgreSqlSSLFactory.toX509Certificates(decoder.decode(clientCertBase64)).get(0);
                keystore.setKeyEntry("client-key", privateKey, null, new Certificate[]{clientCert});
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keystore, null);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            List<X509Certificate> rootCerts = PostgreSqlSSLFactory.toX509Certificates(decoder.decode(rootCertBase64));
            rootCerts.forEach(cert -> {
                try {
                    keystore.setCertificateEntry(cert.getSubjectX500Principal().getName(), (Certificate)cert);
                }
                catch (KeyStoreException e) {
                    log.warn("Error adding certificate to keystore.", (Throwable)e);
                }
            });
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, SecureRandom.getInstanceStrong());
            this.factory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private static final PrivateKey generatePrivateKey(String privateKeyString) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException {
        String pem = privateKeyString.replaceAll("-----.+KEY-----", "").replaceAll("\\s+", "");
        byte[] decoded = Base64.getDecoder().decode(pem.getBytes(StandardCharsets.UTF_8));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey key = (PrivateKey)keyFactory.translateKey(new PKCS1PrivateKey(decoded));
        RSAPrivateCrtKeySpec rsaSpec = keyFactory.getKeySpec(key, RSAPrivateCrtKeySpec.class);
        return keyFactory.generatePrivate(rsaSpec);
    }

    private static List<X509Certificate> toX509Certificates(byte[] sslRootCert) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream certsIn = new ByteArrayInputStream(sslRootCert);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        do {
            X509Certificate cert = (X509Certificate)factory.generateCertificate(certsIn);
            certs.add(cert);
        } while (certsIn.available() > 0);
        return certs;
    }

    static class PKCS1PrivateKey
    implements PrivateKey {
        private static final long serialVersionUID = -880683996554878059L;
        private final byte[] encoded;

        public PKCS1PrivateKey(byte[] encoded) {
            this.encoded = encoded;
        }

        @Override
        public String getAlgorithm() {
            return "RSA";
        }

        @Override
        public String getFormat() {
            return "PKCS#1";
        }

        @Override
        public byte[] getEncoded() {
            return this.encoded;
        }
    }
}

