/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import java.util.function.Supplier;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteODataClient {
    private static final Logger logger = LoggerFactory.getLogger(RemoteODataClient.class);
    private static final String resultContextKey = "result";

    public void processEvent(EventContext context, RequestExecutor executor) {
        CdsProperties.Remote.RemoteServiceConfig.Destination destination = this.getDestination(context);
        ODataProtocol protocol = this.getProtocol(destination);
        if (protocol == null) {
            return;
        }
        HttpClient client = this.getHttpClient(destination);
        String servicePath = this.getServicePath(destination, context);
        logger.debug("CQN >>{}<<", context.get("cqn"));
        Object result = this.handleExceptions(() -> executor.execute(client, destination, protocol, servicePath));
        context.put(resultContextKey, result);
        context.setCompleted();
    }

    private CdsProperties.Remote.RemoteServiceConfig.Destination getDestination(EventContext context) {
        String serviceName = context.getService().getName();
        CdsProperties.Remote.RemoteServiceConfig.Destination destination = context.getCdsRuntime().getEnvironment().getCdsProperties().getRemote().getService(serviceName).getDestination();
        if (StringUtils.isEmpty((String)destination.getName())) {
            destination.setName(serviceName);
        }
        return destination;
    }

    private HttpClient getHttpClient(CdsProperties.Remote.RemoteServiceConfig.Destination destination) {
        DefaultHttpDestination httpDestination;
        if (destination.getProperties().isEmpty()) {
            DestinationOptions.Builder builder = DestinationOptions.builder();
            if (!StringUtils.isEmpty((String)destination.getRetrievalStrategy())) {
                builder.parameter("dwc.destinationRetrievalStrategy", (Object)destination.getRetrievalStrategy());
                builder.parameter("scp.cf.destinationRetrievalStrategy", (Object)destination.getRetrievalStrategy());
            }
            if (!StringUtils.isEmpty((String)destination.getTokenExchangeStrategy())) {
                builder.parameter("scp.cf.destinationTokenExchangeStrategy", (Object)destination.getTokenExchangeStrategy());
            }
            httpDestination = ((Destination)DestinationAccessor.getLoader().tryGetDestination(destination.getName(), builder.build()).getOrElseThrow(failure -> {
                if (failure instanceof DestinationAccessException) {
                    throw (DestinationAccessException)failure;
                }
                throw new DestinationAccessException("Failed to get destination with name '" + destination.getName() + "'.", failure);
            })).asHttp();
        } else {
            httpDestination = new DefaultDestination(destination.getProperties()).asHttp();
        }
        return HttpClientAccessor.getHttpClient((HttpDestinationProperties)httpDestination);
    }

    private String getServicePath(CdsProperties.Remote.RemoteServiceConfig.Destination destination, EventContext context) {
        String servicePath = StringUtils.isEmpty((String)destination.getService()) ? ((RemoteService)context.getService()).getDefinition().getQualifiedName() : destination.getService().trim();
        if (!StringUtils.isEmpty((String)destination.getSuffix())) {
            servicePath = destination.getSuffix().trim() + "/" + servicePath;
        }
        return servicePath;
    }

    private ODataProtocol getProtocol(CdsProperties.Remote.RemoteServiceConfig.Destination destination) {
        if ("odata-v2".equalsIgnoreCase(destination.getType())) {
            return ODataProtocol.V2;
        }
        if ("odata-v4".equalsIgnoreCase(destination.getType())) {
            return ODataProtocol.V4;
        }
        return null;
    }

    private <T> T handleExceptions(Supplier<T> executor) {
        try {
            return executor.get();
        }
        catch (ODataResponseException e) {
            int statusCode = e.getHttpCode();
            String errorMessage = (String)e.getHttpBody().getOrElse((Object)"");
            if (statusCode >= 500 && statusCode < 600) {
                logger.error("Received OData response with status code '{}' and error message '{}'", (Object)statusCode, (Object)errorMessage);
            } else {
                logger.debug("Received OData response with status code '{}' and error message '{}'", (Object)statusCode, (Object)errorMessage);
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_ERROR_RESPONSE, new Object[]{statusCode, e});
        }
    }

    @FunctionalInterface
    public static interface RequestExecutor {
        public Object execute(HttpClient var1, CdsProperties.Remote.RemoteServiceConfig.Destination var2, ODataProtocol var3, String var4);
    }
}

