/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.odata.query.FilterGenerator;
import com.sap.cds.services.impl.odata.query.OrderByGenerator;
import com.sap.cds.services.impl.odata.query.SelectGenerator;
import com.sap.cds.services.impl.odata.query.SkipGenerator;
import com.sap.cds.services.impl.odata.query.TopGenerator;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExpandGenerator
implements AbstractGenerator {
    private final List<StructuredQuery> expanded = new ArrayList<StructuredQuery>();
    private final Set<String> excluded = new HashSet<String>();
    private final CdsEntity entity;
    private final ConversionContext context;

    public ExpandGenerator(CdsEntity entity, ConversionContext context) {
        this.entity = entity;
        this.context = context;
    }

    public void visit(CqnExpand expand) {
        CqnStructuredTypeRef ref = expand.ref();
        if (ref.segments().size() != 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_PATH_EXPR, new Object[0]);
        }
        ODataProtocol protocol = this.context.getProtocol();
        CdsEntity targetEntity = (CdsEntity)this.entity.getTargetOf(ref.firstSegment());
        StructuredQuery subQuery = StructuredQuery.asNestedQueryOnProperty((String)ref.firstSegment(), (ODataProtocol)protocol);
        ArrayList<AbstractGenerator> generators = new ArrayList<AbstractGenerator>();
        generators.add(ExpandGenerator.accept(expand.items(), (AbstractGenerator)new ExpandGenerator(targetEntity, this.context)));
        if (protocol == ODataProtocol.V4) {
            generators.add(ExpandGenerator.accept(expand.items(), (AbstractGenerator)new SelectGenerator(targetEntity)));
            if (!CdsModelUtils.isSingleValued((CdsType)this.entity.getAssociation(ref.firstSegment()).getType())) {
                expand.ref().rootSegment().filter().ifPresent(f -> generators.add(ExpandGenerator.accept((CqnToken)f, (AbstractGenerator)new FilterGenerator(targetEntity, this.context))));
                generators.add(ExpandGenerator.accept(expand.orderBy(), (AbstractGenerator)new OrderByGenerator(targetEntity, this.context)));
                generators.add(ExpandGenerator.accept((CqnToken)expand, (AbstractGenerator)new TopGenerator()));
                generators.add(ExpandGenerator.accept((CqnToken)expand, (AbstractGenerator)new SkipGenerator()));
            }
        }
        generators.forEach(generator -> generator.apply(subQuery));
        this.expanded.add(subQuery);
    }

    private static AbstractGenerator accept(CqnToken token, AbstractGenerator generator) {
        token.accept((CqnVisitor)generator);
        return generator;
    }

    private static AbstractGenerator accept(Iterable<? extends CqnToken> tokens, AbstractGenerator generator) {
        tokens.forEach(t -> t.accept((CqnVisitor)generator));
        return generator;
    }

    public void visit(CqnSelect select) {
        this.excluded.addAll(select.excluding());
    }

    @Override
    public void apply(StructuredQuery query) {
        this.expanded.removeIf(q -> this.excluded.contains(q.getEntityOrPropertyName()));
        if (this.expanded.size() > 0) {
            query.select(this.expanded.toArray(new StructuredQuery[this.expanded.size()]));
        }
    }
}

