/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.List;
import java.util.Locale;

public class SearchGenerator
implements AbstractGenerator {
    private final SearchPredicateAnalyzer analyzer = new SearchPredicateAnalyzer();
    private final ConversionContext context;

    public SearchGenerator(ConversionContext context) {
        this.context = context;
    }

    public void visit(CqnSelect select) {
        select.search().ifPresent(s -> s.accept((CqnVisitor)this.analyzer));
    }

    @Override
    public void apply(StructuredQuery query) {
        String searchExpression = this.analyzer.getSearchExpression();
        if (searchExpression != null) {
            if (this.context.getProtocol() == ODataProtocol.V4) {
                query.search(searchExpression);
            } else {
                query.withCustomParameter("search", searchExpression);
            }
        }
    }

    private static String escapeEscapeCharacter(String s) {
        String escaped = "\\\\";
        return s.replace("\\", escaped).replace("%5C", escaped);
    }

    private static String escapeDoubleQuotes(String s) {
        String escaped = "\\\"";
        return SearchGenerator.escapeEscapeCharacter(s).replace("\"", escaped).replace("%22", escaped);
    }

    private static class SearchPredicateAnalyzer
    implements CqnVisitor {
        private final Stack<String> search = new Stack();

        private SearchPredicateAnalyzer() {
        }

        public void visit(CqnSearchPredicate searchPredicate) {
            String escapedTerm = SearchGenerator.escapeDoubleQuotes(searchPredicate.searchTerm());
            this.search.push((Object)("\"" + escapedTerm + "\""));
        }

        public void visit(CqnConnectivePredicate connective) {
            List expressions = this.search.pop(connective.predicates().size());
            String operator = connective.operator().toString().toUpperCase(Locale.ENGLISH);
            this.search.push((Object)("(" + String.join((CharSequence)(" " + operator + " "), expressions) + ")"));
        }

        public void visit(CqnNegation neg) {
            this.search.push((Object)("NOT(" + (String)this.search.pop() + ")"));
        }

        public String getSearchExpression() {
            if (this.search.isEmpty()) {
                return null;
            }
            return (String)this.search.pop();
        }
    }
}

