/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.odata.serialization.ODataJsonSerializer;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;

class ODataV2JsonSerializer
implements ODataJsonSerializer {
    private static ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS).registerModule((Module)new SimpleModule().addSerializer(new NumberStringSerializer<Long>(Long.class)).addSerializer(new NumberStringSerializer<Long>(Long.TYPE)).addSerializer(new NumberStringSerializer<Double>(Double.class)).addSerializer(new NumberStringSerializer<Double>(Double.TYPE)).addSerializer(new NumberStringSerializer<BigDecimal>(BigDecimal.class)).addSerializer((JsonSerializer)new InstantSerializer(Instant.class)).addSerializer((JsonSerializer)new LocalDateSerializer(LocalDate.class)).addSerializer((JsonSerializer)new LocalTimeSerializer(LocalTime.class)));

    ODataV2JsonSerializer() {
    }

    @Override
    public String serialize(Map<String, Object> row) {
        try {
            return mapper.writeValueAsString(row);
        }
        catch (JsonProcessingException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_JSON_SERIALIZATION, new Object[]{e});
        }
    }

    private static class LocalTimeSerializer
    extends StdSerializer<LocalTime> {
        private static final long serialVersionUID = 1L;

        public LocalTimeSerializer(Class<LocalTime> t) {
            super(t);
        }

        public void serialize(LocalTime localTime, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String nanoOutput = "";
            long nanos = localTime.getNano();
            if (nanos > 0L) {
                int precision = 9;
                while (nanos % 10L == 0L) {
                    nanos /= 10L;
                    --precision;
                }
                nanoOutput = String.format(".%0" + precision + "d", nanos);
            }
            gen.writeString(String.format("PT%dH%dM%d%sS", localTime.getHour(), localTime.getMinute(), localTime.getSecond(), nanoOutput));
        }
    }

    private static class LocalDateSerializer
    extends StdSerializer<LocalDate> {
        private static final long serialVersionUID = 1L;

        public LocalDateSerializer(Class<LocalDate> t) {
            super(t);
        }

        public void serialize(LocalDate localDate, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(String.format("/Date(%d)/", localDate.toEpochDay() * 86400000L));
        }
    }

    private static class InstantSerializer
    extends StdSerializer<Instant> {
        private static final long serialVersionUID = 1L;

        public InstantSerializer(Class<Instant> t) {
            super(t);
        }

        public void serialize(Instant instant, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(String.format("/Date(%d)/", instant.toEpochMilli()));
        }
    }

    private static class NumberStringSerializer<T extends Number>
    extends StdSerializer<T> {
        private static final long serialVersionUID = 1L;

        public NumberStringSerializer(Class<T> t) {
            super(t);
        }

        public void serialize(T number, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(number.toString());
        }
    }
}

