/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.utils;

import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsTypeUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class ODataTypeUtils {
    public static final long FACTOR_MILLIS_TO_DAYS = 86400000L;

    public static Object toCloudSdkType(Object value, CdsBaseType type, ODataProtocol protocol) {
        if (value == null) {
            return null;
        }
        if (type != null) {
            switch (type) {
                case UUID: {
                    return UUID.fromString((String)value);
                }
                case STRING: {
                    return value.toString();
                }
            }
        }
        if (protocol == ODataProtocol.V2 && value instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)value, LocalTime.MIDNIGHT);
        }
        if (value instanceof Instant) {
            return OffsetDateTime.ofInstant((Instant)value, ZoneOffset.UTC);
        }
        return value;
    }

    public static CdsBaseType getCdsType(CdsStructuredType structuredType, CqnElementRef ref) {
        CdsElement element = null;
        for (CqnReference.Segment segment : ref.segments()) {
            element = structuredType.getElement(segment.id());
            if (!element.getType().isAssociation()) continue;
            structuredType = structuredType.getTargetOf(element.getName());
        }
        if (element != null) {
            if (element.getType().isSimple()) {
                return ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType();
            }
            if (element.getType().isArrayed()) {
                CdsType type = element.getType();
                while (type.isArrayed()) {
                    type = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
                }
                if (type.isSimple()) {
                    return ((CdsSimpleType)type.as(CdsSimpleType.class)).getType();
                }
            }
        }
        String path = ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("."));
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_REF_TYPE, new Object[]{path, structuredType.getQualifiedName()});
    }

    public static <T extends Map<String, Object>> T toCdsTypes(CdsStructuredType structuredType, T data) {
        return (T)ODataTypeUtils.toCdsTypes(structuredType, Arrays.asList(data)).get(0);
    }

    public static <T extends Iterable<? extends Map<String, Object>>> T toCdsTypes(CdsStructuredType structuredType, T data) {
        DataProcessor.create().action((currentStructType, row) -> {
            for (String key : new HashSet(row.keySet())) {
                CdsType elementType;
                Optional element = currentStructType.findElement(key);
                if (!element.isPresent() || !(elementType = ((CdsElement)element.get()).getType()).isSimple()) continue;
                row.put(key, ODataTypeUtils.toCdsType(row.get(key), ((CdsSimpleType)elementType.as(CdsSimpleType.class)).getType()));
            }
        }).process(data, structuredType);
        return data;
    }

    public static Iterable<?> toCdsTypes(CdsBaseType type, Iterable<? extends Object> data) {
        ArrayList result = new ArrayList();
        data.forEach(e -> result.add(ODataTypeUtils.toCdsType(e, type)));
        return result;
    }

    public static Object toCdsType(Object value, CdsBaseType type) {
        if (value == null) {
            return value;
        }
        try {
            if (type.javaType().isInstance(value)) {
                return value;
            }
            switch (type) {
                case DECIMAL: 
                case DECIMAL_FLOAT: {
                    if (value instanceof Double || value instanceof Float) {
                        return new BigDecimal(ODataTypeUtils.handlePrimitiveTypesDouble(value));
                    }
                    if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                        return new BigDecimal(ODataTypeUtils.handlePrimitiveTypesLong(value));
                    }
                    if (!(value instanceof BigInteger)) break;
                    return new BigDecimal((BigInteger)value);
                }
                case DOUBLE: {
                    if (value instanceof BigDecimal) {
                        return ((BigDecimal)value).doubleValue();
                    }
                    if (value instanceof BigInteger) {
                        return ((BigInteger)value).doubleValue();
                    }
                    if (!(value instanceof Number)) break;
                    return ODataTypeUtils.handlePrimitiveTypesDouble(value);
                }
                case INTEGER: {
                    if (value instanceof BigDecimal) {
                        return ((BigDecimal)value).intValue();
                    }
                    if (value instanceof BigInteger) {
                        return ((BigInteger)value).intValue();
                    }
                    if (!(value instanceof Number)) break;
                    return (int)ODataTypeUtils.handlePrimitiveTypesLong(value);
                }
                case INTEGER64: {
                    if (value instanceof BigDecimal) {
                        return ((BigDecimal)value).longValue();
                    }
                    if (value instanceof BigInteger) {
                        return ((BigInteger)value).longValue();
                    }
                    if (!(value instanceof Number)) break;
                    return ODataTypeUtils.handlePrimitiveTypesLong(value);
                }
                case DATETIME: 
                case TIMESTAMP: {
                    if (value instanceof LocalDateTime) {
                        return ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
                    }
                    if (value instanceof OffsetDateTime) {
                        return ((OffsetDateTime)value).toInstant();
                    }
                    if (value instanceof LocalDate) {
                        return ((LocalDate)value).atStartOfDay().toInstant(ZoneOffset.UTC);
                    }
                    if (!ODataTypeUtils.isJsDate(value)) break;
                    return Instant.ofEpochMilli(ODataTypeUtils.jsDateToEpochMillis((String)value));
                }
                case DATE: {
                    if (value instanceof LocalDateTime) {
                        return ((LocalDateTime)value).toLocalDate();
                    }
                    if (value instanceof OffsetDateTime) {
                        return ((OffsetDateTime)value).toLocalDate();
                    }
                    if (!ODataTypeUtils.isJsDate(value)) break;
                    long epochMillis = ODataTypeUtils.jsDateToEpochMillis((String)value);
                    return LocalDate.ofEpochDay(epochMillis / 86400000L);
                }
                case TIME: {
                    if (value instanceof LocalDateTime) {
                        return ((LocalDateTime)value).toLocalTime();
                    }
                    if (value instanceof OffsetDateTime) {
                        return ((OffsetDateTime)value).toLocalTime();
                    }
                    if (!(value instanceof String) || !((String)value).startsWith("P")) break;
                    Duration duration = Duration.parse((String)value);
                    return LocalTime.of(0, 0).plus(duration);
                }
                case UUID: {
                    if (!(value instanceof UUID)) break;
                    return value.toString();
                }
                case STRING: 
                case LARGE_STRING: {
                    return value.toString();
                }
                case BINARY: 
                case LARGE_BINARY: {
                    if (!(value instanceof String)) break;
                    return Base64.decodeBase64((String)((String)value));
                }
            }
            return CdsTypeUtils.parse((CdsBaseType)type, (String)value.toString());
        }
        catch (CdsDataException | ClassCastException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_TYPE_CONV, new Object[]{value, value.getClass(), type, e});
        }
    }

    private static boolean isJsDate(Object value) {
        return value instanceof String && ((String)value).startsWith("/Date(");
    }

    private static long jsDateToEpochMillis(String jsDate) {
        String time = jsDate.substring(6, jsDate.length() - 2);
        int zoneStart = time.lastIndexOf("+");
        if (zoneStart < 1) {
            zoneStart = time.lastIndexOf("-");
        }
        return Long.parseLong(time.substring(0, zoneStart > 0 ? zoneStart : time.length()));
    }

    private static long handlePrimitiveTypesLong(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Float) {
            return ((Float)value).longValue();
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        return (Long)value;
    }

    private static double handlePrimitiveTypesDouble(Object value) {
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return (Double)value;
    }

    public static boolean isSimpleType(CdsType type) {
        return type != null && type.isSimple();
    }

    public static boolean isArrayedSimpleType(CdsType type) {
        return type != null && type.isArrayed() && ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().isSimple();
    }

    public static boolean isStructuredType(CdsType type) {
        return type != null && type.isStructured();
    }

    public static boolean isArrayedStruturedType(CdsType type) {
        return type != null && type.isArrayed() && ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().isStructured();
    }
}

