/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;

public class InlineCountGenerator
implements AbstractGenerator {
    private final ConversionContext context;
    private boolean count = false;

    public InlineCountGenerator(ConversionContext context) {
        this.context = context;
    }

    public void visit(CqnSelect select) {
        this.count = select.hasInlineCount();
    }

    @Override
    public void apply(StructuredQuery query) {
        if (this.count) {
            if (this.context.getProtocol() == ODataProtocol.V2) {
                query.withCustomParameter("$inlinecount", "allpages");
            } else {
                query.withCustomParameter("$count", "true");
            }
        }
    }

    public boolean isInlineCountRequested() {
        return this.count;
    }
}

