/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnEntitySelector;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.odata.RemoteODataClient;
import com.sap.cds.services.impl.odata.query.StructuredQueryBuilder;
import com.sap.cds.services.impl.odata.serialization.ODataJsonSerializer;
import com.sap.cds.services.impl.odata.uri.UriGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.impl.odata.utils.CqnToCloudSdkConverter;
import com.sap.cds.services.impl.odata.utils.ODataDataUtils;
import com.sap.cds.services.impl.odata.utils.ODataRequestUtils;
import com.sap.cds.services.impl.odata.utils.ODataTypeUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.ProjectionResolver;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataFunctionParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestAction;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestBatch;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestCreate;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestDelete;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestFunction;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestRead;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultMultipartGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestUpdate;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import com.sap.cloud.sdk.datamodel.odata.client.request.UpdateStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={RemoteService.class})
public class RemoteODataHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteODataHandler.class);
    private final RemoteODataClient client = new RemoteODataClient();

    @On
    @HandlerOrder(value=10900)
    public void read(CdsReadEventContext context) {
        this.client.processEvent((EventContext)context, (httpClient, config, protocol, servicePath) -> {
            ODataRequestResultGeneric result;
            ProjectionResolver<CqnSelect> resolver = this.resolveProjection(context.getCqn(), (EventContext)context);
            CqnSelect projected = (CqnSelect)resolver.getResolvedStatement();
            CdsEntity projectedTarget = this.getTargetEntityFromProjection((CqnStatement)projected, (EventContext)context);
            ConversionContext cc = new ConversionContext(context.getCqnNamedValues(), protocol, (EventContext)context);
            UriGenerator uriGenerator = new UriGenerator(cc);
            ODataResourcePath entityPath = uriGenerator.analyze((CqnStatement)projected);
            boolean isCollection = uriGenerator.isCollection();
            StructuredQueryBuilder sqb = StructuredQueryBuilder.forEntity(cc, entityPath.toEncodedPathString(), projectedTarget);
            this.handleQueryParameters(projected, isCollection, sqb);
            StructuredQuery query = sqb.build();
            ODataRequestUtils.prepareQuery(query, (EventContext)context);
            logger.debug("GET >>{}{}?{}<<", new Object[]{servicePath, entityPath, query.getQueryString()});
            try {
                ODataRequestRead readRequest = new ODataRequestRead(servicePath, entityPath, query.getEncodedQueryString(), protocol);
                ODataRequestUtils.prepareRequest(readRequest, config, (EventContext)context);
                result = readRequest.execute(httpClient);
            }
            catch (ODataResponseException e) {
                if (e.getHttpCode() == 404 && !uriGenerator.isCollection()) {
                    logger.debug("Received OData response with status code '404' for GET request: Returning empty result");
                    return ResultBuilder.selectedRows(Collections.emptyList()).result();
                }
                throw e;
            }
            List<Map<String, Object>> resultList = isCollection ? ODataDataUtils.entityCollection(result, (CdsStructuredType)projectedTarget, protocol) : Arrays.asList(ODataDataUtils.entity(result, (CdsStructuredType)projectedTarget, protocol));
            ResultBuilder resultBuilder = ResultBuilder.selectedRows((List)resolver.transform(resultList));
            if (isCollection && projected.hasInlineCount()) {
                resultBuilder.inlineCount(result.getInlineCount());
            }
            return ODataTypeUtils.toCdsTypes((CdsStructuredType)context.getTarget(), resultBuilder.result());
        });
    }

    @VisibleForTesting
    void handleQueryParameters(CqnSelect projected, boolean isCollection, StructuredQueryBuilder sqb) {
        sqb.select(projected);
        sqb.expand(projected);
        if (isCollection) {
            sqb.filter(projected.where());
            sqb.search(projected.search());
            sqb.orderBy(projected.orderBy());
            sqb.top((CqnEntitySelector)projected);
            sqb.skip((CqnEntitySelector)projected);
            sqb.inlineCount(projected);
        }
    }

    @On
    @HandlerOrder(value=10900)
    public void create(CdsCreateEventContext context) {
        this.client.processEvent((EventContext)context, (httpClient, config, protocol, servicePath) -> {
            ODataDataUtils.clean(context.getCqn().entries(), (CdsStructuredType)context.getTarget());
            ProjectionResolver<CqnInsert> resolver = this.resolveProjection(context.getCqn(), (EventContext)context);
            CqnInsert projected = (CqnInsert)resolver.getResolvedStatement();
            CdsEntity projectedTarget = this.getTargetEntityFromProjection((CqnStatement)projected, (EventContext)context);
            ConversionContext cc = new ConversionContext(protocol, (EventContext)context);
            UriGenerator uriGenerator = new UriGenerator(cc);
            ODataResourcePath entityPath = uriGenerator.analyze((CqnStatement)projected);
            logger.debug("POST >>{}{}<<", (Object)servicePath, (Object)entityPath);
            if (!uriGenerator.isCollection()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_ONLY_COLLECTION, new Object[0]);
            }
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            ODataJsonSerializer serializer = ODataJsonSerializer.create(protocol);
            ArrayList<ODataRequestCreate> requests = new ArrayList<ODataRequestCreate>();
            for (Map entry : projected.entries()) {
                String serializedEntry = serializer.serialize(entry);
                ODataRequestCreate request = new ODataRequestCreate(servicePath, entityPath, serializedEntry, protocol);
                ODataRequestUtils.prepareRequest(request, config, (EventContext)context);
                requests.add(request);
            }
            if (requests.size() == 1) {
                ODataRequestResultGeneric requestResult = ((ODataRequestCreate)requests.get(0)).execute(httpClient);
                result.add(ODataDataUtils.entity(requestResult, (CdsStructuredType)projectedTarget, protocol));
            } else if (requests.size() > 1) {
                ODataRequestBatch.Changeset changeset = new ODataRequestBatch(servicePath, protocol).beginChangeset();
                requests.forEach(arg_0 -> ((ODataRequestBatch.Changeset)changeset).addCreate(arg_0));
                ODataRequestBatch batchRequest = changeset.endChangeset();
                ODataRequestUtils.prepareRequest(batchRequest, config, (EventContext)context);
                ODataRequestResultMultipartGeneric batchResult = batchRequest.execute(httpClient);
                for (ODataRequestCreate request : requests) {
                    result.add(ODataDataUtils.entity(batchResult.getResult((ODataRequestGeneric)request), (CdsStructuredType)projectedTarget, protocol));
                }
            }
            Result transformedResult = ResultBuilder.insertedRows((List)resolver.transform(result)).result();
            return ODataTypeUtils.toCdsTypes((CdsStructuredType)context.getTarget(), transformedResult);
        });
    }

    @On
    @HandlerOrder(value=10900)
    public void update(CdsUpdateEventContext context) {
        this.client.processEvent((EventContext)context, (httpClient, config, protocol, servicePath) -> {
            ODataDataUtils.clean(context.getCqn().entries(), (CdsStructuredType)context.getTarget());
            ProjectionResolver<CqnUpdate> resolver = this.resolveProjection(context.getCqn(), (EventContext)context);
            CqnUpdate projected = (CqnUpdate)resolver.getResolvedStatement();
            CdsEntity projectedTarget = this.getTargetEntityFromProjection((CqnStatement)projected, (EventContext)context);
            ODataJsonSerializer serializer = ODataJsonSerializer.create(protocol);
            int dataBatches = projected.entries().size();
            List<Map<String, Object>> batches = this.valueSetsOrEmptyParameters(context.getCqnValueSets(), dataBatches);
            if (dataBatches != 1 && dataBatches != batches.size()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_BATCH_UPDATE, new Object[]{batches.size(), dataBatches});
            }
            int[] updated = new int[batches.size()];
            ArrayList<Map> updatedData = new ArrayList<Map>(batches.size());
            ArrayList<ODataRequestUpdate> requests = new ArrayList<ODataRequestUpdate>(batches.size());
            ArrayList<Map> requestEntries = new ArrayList<Map>(batches.size());
            for (int i = 0; i < batches.size(); ++i) {
                ConversionContext cc = new ConversionContext(batches.get(i), protocol, (EventContext)context);
                UriGenerator uriGenerator = new UriGenerator(cc);
                Map entry = (Map)projected.entries().get(dataBatches > 1 ? i : 0);
                ODataResourcePath entityPath = uriGenerator.analyze((CqnStatement)projected, entry);
                logger.debug("PATCH >>{}{}<<", (Object)servicePath, (Object)entityPath);
                if (uriGenerator.isCollection()) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_ONLY_ENTITY, new Object[0]);
                }
                String serializedEntry = serializer.serialize(entry);
                ODataRequestUpdate request = new ODataRequestUpdate(servicePath, entityPath, serializedEntry, UpdateStrategy.MODIFY_WITH_PATCH, null, protocol);
                ODataRequestUtils.prepareRequest(request, config, (EventContext)context);
                requests.add(request);
                requestEntries.add(entry);
            }
            if (requests.size() == 1) {
                try {
                    ODataRequestResultGeneric requestResult = ((ODataRequestUpdate)requests.get(0)).execute(httpClient);
                    updated[0] = 1;
                    boolean noContent = requestResult.getHttpResponse().getStatusLine().getStatusCode() == 204;
                    updatedData.add(noContent ? DataUtils.copyMap((Map)((Map)requestEntries.get(0))) : ODataDataUtils.entity(requestResult, (CdsStructuredType)projectedTarget, protocol));
                }
                catch (ODataResponseException e) {
                    if (e.getHttpCode() == 404) {
                        updated[0] = 0;
                        updatedData.add(new HashMap());
                        logger.debug("Received OData response with status code '404' for PATCH request: Returning empty result");
                    }
                    throw e;
                }
            } else if (requests.size() > 1) {
                ODataRequestBatch.Changeset changeset = new ODataRequestBatch(servicePath, protocol).beginChangeset();
                requests.forEach(arg_0 -> ((ODataRequestBatch.Changeset)changeset).addUpdate(arg_0));
                ODataRequestBatch batchRequest = changeset.endChangeset();
                ODataRequestUtils.prepareRequest(batchRequest, config, (EventContext)context);
                ODataRequestResultMultipartGeneric batchResult = batchRequest.execute(httpClient);
                for (int i = 0; i < requests.size(); ++i) {
                    try {
                        ODataRequestResultGeneric requestResult = batchResult.getResult((ODataRequestGeneric)requests.get(i));
                        updated[i] = 1;
                        boolean noContent = requestResult.getHttpResponse().getStatusLine().getStatusCode() == 204;
                        updatedData.add(noContent ? DataUtils.copyMap((Map)((Map)requestEntries.get(i))) : ODataDataUtils.entity(requestResult, (CdsStructuredType)projectedTarget, protocol));
                        continue;
                    }
                    catch (ODataResponseException e) {
                        if (e.getHttpCode() == 404) {
                            updated[i] = 0;
                            updatedData.add(new HashMap());
                            logger.debug("Received OData response with status code '404' for PATCH request: Returning empty result");
                            continue;
                        }
                        throw e;
                    }
                }
            }
            ResultBuilder transformedResultBuilder = ResultBuilder.batchUpdate();
            List transformedData = resolver.transform(updatedData);
            for (int i = 0; i < updated.length; ++i) {
                transformedResultBuilder.addUpdatedRows((long)updated[i], (Map)transformedData.get(i));
            }
            Result transformedResult = transformedResultBuilder.result();
            return ODataTypeUtils.toCdsTypes((CdsStructuredType)context.getTarget(), transformedResult);
        });
    }

    @On
    @HandlerOrder(value=10900)
    public void delete(CdsDeleteEventContext context) {
        this.client.processEvent((EventContext)context, (httpClient, config, protocol, servicePath) -> {
            CqnDelete projected = (CqnDelete)this.resolveProjection(context.getCqn(), (EventContext)context).getResolvedStatement();
            List<Map<String, Object>> batches = this.valueSetsOrEmptyParameters(context.getCqnValueSets(), 1);
            int[] deleted = new int[batches.size()];
            ArrayList<ODataRequestDelete> requests = new ArrayList<ODataRequestDelete>(batches.size());
            for (int i = 0; i < batches.size(); ++i) {
                ConversionContext cc = new ConversionContext(batches.get(i), protocol, (EventContext)context);
                UriGenerator uriGenerator = new UriGenerator(cc);
                ODataResourcePath entityPath = uriGenerator.analyze((CqnStatement)projected);
                logger.debug("DELETE >>{}{}<<", (Object)servicePath, (Object)entityPath);
                if (uriGenerator.isCollection()) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_ONLY_ENTITY, new Object[0]);
                }
                ODataRequestDelete request = new ODataRequestDelete(servicePath, entityPath, null, protocol);
                ODataRequestUtils.prepareRequest(request, config, (EventContext)context);
                requests.add(request);
            }
            if (requests.size() == 1) {
                try {
                    ((ODataRequestDelete)requests.get(0)).execute(httpClient);
                    deleted[0] = 1;
                }
                catch (ODataResponseException e) {
                    if (e.getHttpCode() == 404) {
                        deleted[0] = 0;
                        logger.debug("Received OData response with status code '404' for DELETE request: Returning empty result");
                    }
                    throw e;
                }
            } else if (requests.size() > 1) {
                ODataRequestBatch.Changeset changeset = new ODataRequestBatch(servicePath, protocol).beginChangeset();
                requests.forEach(arg_0 -> ((ODataRequestBatch.Changeset)changeset).addDelete(arg_0));
                ODataRequestBatch batchRequest = changeset.endChangeset();
                ODataRequestUtils.prepareRequest(batchRequest, config, (EventContext)context);
                ODataRequestResultMultipartGeneric batchResult = batchRequest.execute(httpClient);
                for (int i = 0; i < requests.size(); ++i) {
                    try {
                        batchResult.getResult((ODataRequestGeneric)requests.get(i));
                        deleted[i] = 1;
                        continue;
                    }
                    catch (ODataResponseException e) {
                        if (e.getHttpCode() == 404) {
                            deleted[i] = 0;
                            logger.debug("Received OData response with status code '404' for DELETE request: Returning empty result");
                            continue;
                        }
                        throw e;
                    }
                }
            }
            return ResultBuilder.deletedRows((int[])deleted).result();
        });
    }

    @On(event={"*"})
    @HandlerOrder(value=10901)
    public void handleActionAndFunction(EventContext context) {
        String event = context.getEvent();
        CdsService service = ((RemoteService)context.getService()).getDefinition();
        Optional action = CdsModelUtils.findAction((CdsService)service, (CdsEntity)context.getTarget(), (String)context.getEvent());
        Optional function = CdsModelUtils.findFunction((CdsService)service, (CdsEntity)context.getTarget(), (String)context.getEvent());
        if (!action.isPresent() && !function.isPresent()) {
            logger.debug("Found no function or action matching '{}' in service '{}' for target '{}'", new Object[]{event, service, context.getTarget()});
            return;
        }
        this.client.processEvent(context, (httpClient, config, protocol, servicePath) -> {
            ODataRequestResultGeneric result;
            CdsType type;
            ODataResourcePath resourcePath;
            CqnSelect select = (CqnSelect)context.get("cqn");
            CdsEntity target = context.getTarget();
            String operation = action.map(a -> a.getQualifiedName()).orElse(function.map(f -> f.getQualifiedName()).orElse(null));
            boolean isServiceBound = operation.startsWith(service.getQualifiedName());
            if (!isServiceBound && select == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_MISSING_STATEMENT, new Object[0]);
            }
            Object operationName = isServiceBound ? context.getEvent() : (protocol == ODataProtocol.V4 ? service.getQualifiedName() + "." + context.getEvent() : target.getName() + "_" + operation);
            ConversionContext cc = new ConversionContext(protocol, context);
            if (protocol == ODataProtocol.V2) {
                resourcePath = ODataResourcePath.of((String)operationName);
            } else {
                UriGenerator uriGenerator = new UriGenerator(cc, true);
                resourcePath = uriGenerator.analyze((CqnStatement)select);
                resourcePath.addSegment((String)operationName);
            }
            if (action.isPresent()) {
                ODataRequestAction request;
                type = ((CdsAction)action.get()).returnType().orElse(null);
                if (protocol == ODataProtocol.V4) {
                    ODataJsonSerializer serializer = ODataJsonSerializer.create(protocol);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    ((CdsAction)action.get()).parameters().forEach(e -> parameters.put(e.getName(), context.get(e.getName())));
                    String actionParameters = serializer.serialize(parameters);
                    request = new ODataRequestAction(servicePath, resourcePath, actionParameters, protocol);
                    logger.debug("POST >>{}{}<<", (Object)servicePath, (Object)resourcePath);
                } else {
                    Map<String, Expressions.OperandSingle> parameters = ((CdsAction)action.get()).parameters().filter(param -> context.get(param.getName()) != null).collect(Collectors.toMap(CdsParameter::getName, e -> CqnToCloudSdkConverter.convert(context.get(e.getName()), null, ((CdsSimpleType)e.getType().as(CdsSimpleType.class)).getType(), cc)));
                    request = new ODataRequestAction(servicePath, resourcePath, null, protocol);
                    if (select != null) {
                        CqnAnalyzer analyzer = CqnAnalyzer.create((CdsModel)context.getModel());
                        AnalysisResult analysisResult = analyzer.analyze(select);
                        Map keys = analysisResult.targetKeys();
                        target.keyElements().forEach(key -> parameters.put(key.getName(), CqnToCloudSdkConverter.convert(keys.get(key.getName()), (CdsStructuredType)target, ((CdsSimpleType)key.getType().as(CdsSimpleType.class)).getType(), cc)));
                    }
                    parameters.entrySet().stream().forEach(entry -> request.addQueryParameter((String)entry.getKey(), ODataUriFactory.encodeQuery((String)((Expressions.OperandSingle)entry.getValue()).getExpression(protocol))));
                    logger.debug("POST >>{}{}?{}<<", new Object[]{servicePath, resourcePath, request.getRequestQuery()});
                }
                ODataRequestUtils.prepareRequest(request, config, context);
                result = request.execute(httpClient);
            } else {
                type = ((CdsFunction)function.get()).getReturnType();
                Map<String, Object> parameters = ((CdsFunction)function.get()).parameters().filter(param -> context.get(param.getName()) != null || protocol == ODataProtocol.V4).collect(Collectors.toMap(CdsParameter::getName, e -> CqnToCloudSdkConverter.convert(context.get(e.getName()), null, ((CdsSimpleType)e.getType().as(CdsSimpleType.class)).getType(), cc)));
                if (protocol == ODataProtocol.V2 && select != null) {
                    CqnAnalyzer analyzer = CqnAnalyzer.create((CdsModel)context.getModel());
                    AnalysisResult analysisResult = analyzer.analyze(select);
                    Map keys = analysisResult.targetKeys();
                    target.keyElements().forEach(key -> parameters.put(key.getName(), CqnToCloudSdkConverter.convert(keys.get(key.getName()), (CdsStructuredType)target, ((CdsSimpleType)key.getType().as(CdsSimpleType.class)).getType(), cc)));
                }
                ODataFunctionParameters odataParameters = ODataFunctionParameters.of(parameters, (ODataProtocol)protocol);
                ODataRequestFunction request = new ODataRequestFunction(servicePath, resourcePath, odataParameters, null, protocol);
                logger.debug("GET >>{}{}?{}<<", new Object[]{servicePath, resourcePath, request.getQuery()});
                ODataRequestUtils.prepareRequest(request, config, context);
                result = request.execute(httpClient);
            }
            if (result.getHttpResponse().getStatusLine().getStatusCode() == 204) {
                return null;
            }
            return ODataDataUtils.operation(result, type, protocol, (String)operationName);
        });
    }

    private <T extends CqnStatement> ProjectionResolver<T> resolveProjection(T cqn, EventContext context) {
        CqnAnalyzer analyzer = CqnAnalyzer.create((CdsModel)context.getModel());
        String serviceName = ((RemoteService)context.getService()).getDefinition().getQualifiedName();
        ProjectionResolver resolver = ProjectionResolver.create((CdsModel)context.getModel(), cqn).condition((prev, curr, next) -> !analyzer.analyze(next.ref()).rootEntity().getQualifier().equals(serviceName)).resolveAliases().resolveAll();
        logger.debug("CQN (projected) >>{}<<", (Object)resolver.getResolvedStatement());
        return resolver;
    }

    private CdsEntity getTargetEntityFromProjection(CqnStatement cqn, EventContext context) {
        return CdsModelUtils.getEntityPath((CqnStructuredTypeRef)cqn.ref(), (CdsModel)context.getModel()).target().entity();
    }

    private List<Map<String, Object>> valueSetsOrEmptyParameters(Iterable<Map<String, Object>> cqnValueSets, int defaultBatchSize) {
        ArrayList<Map<String, Object>> valueSetsOrEmptyParameters = new ArrayList<Map<String, Object>>();
        cqnValueSets.forEach(valueSetsOrEmptyParameters::add);
        if (valueSetsOrEmptyParameters.isEmpty()) {
            for (int i = 0; i < defaultBatchSize; ++i) {
                valueSetsOrEmptyParameters.add(Collections.emptyMap());
            }
        }
        return valueSetsOrEmptyParameters;
    }
}

