/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.impl.odata.utils.CqnToCloudSdkConverter;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.OrderExpression;
import com.sap.cloud.sdk.datamodel.odata.client.query.Order;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.Locale;

public class OrderByGenerator
implements AbstractGenerator,
CqnVisitor {
    private OrderExpression orderExpr = null;
    private final CdsEntity entity;
    private final ConversionContext context;

    public OrderByGenerator(CdsEntity entity, ConversionContext context) {
        this.entity = entity;
        this.context = context;
    }

    public void visit(CqnSortSpecification sortSpec) {
        Expressions.OperandSingle operand = CqnToCloudSdkConverter.convert(sortSpec.value(), (CdsStructuredType)this.entity, this.context);
        String item = operand.getExpression(this.context.getProtocol());
        if (sortSpec.order() != null) {
            this.addOrderExpr(item, Order.valueOf((String)sortSpec.order().toString().toUpperCase(Locale.US)));
        } else {
            this.addOrderExpr(item, Order.ASC);
        }
    }

    private void addOrderExpr(String fieldName, Order order) {
        this.orderExpr = this.orderExpr == null ? OrderExpression.of((String)fieldName, (Order)order) : this.orderExpr.and(fieldName, order);
    }

    @Override
    public void apply(StructuredQuery query) {
        if (this.orderExpr != null) {
            query.orderBy(this.orderExpr);
        }
    }
}

