/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.utils;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FieldReference;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBoolean;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueString;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

class ExtendedMatchesPattern
implements ValueBoolean {
    private static final String FUNCTION = "matchesPattern";
    private final CqnElementRef ref;
    private final CqnValue pattern;
    private final CqnValue options;

    ExtendedMatchesPattern(CqnElementRef ref, CqnValue pattern, CqnValue options) {
        this.ref = ref;
        this.pattern = pattern;
        this.options = options;
    }

    @Nonnull
    public String getExpression(@Nonnull ODataProtocol protocol, @Nonnull Map<String, Predicate<FieldReference>> prefixes) {
        return String.format("%s(%s,%s,%s)", FUNCTION, FieldReference.of((String)this.ref.displayName()).getExpression(protocol, prefixes), ValueString.literal((String)((String)this.pattern.asLiteral().asString().value())).getExpression(protocol, prefixes), ValueString.literal((String)((String)this.options.asLiteral().asString().value())).getExpression(protocol, prefixes));
    }
}

