/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.utils;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.impl.odata.utils.ODataTypeUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.request.NumberDeserializationStrategy;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ODataDataUtils {
    private static final String ODATA_V2_RESULTS = "results";
    private static final String ODATA_V2_VALUE = "value";

    public static Map<String, Object> entity(ODataRequestResultGeneric result, CdsStructuredType resultType, ODataProtocol protocol) {
        return ODataDataUtils.normalize(ODataDataUtils.preciseNumbers(result).asMap(), resultType, protocol);
    }

    public static List<Map<String, Object>> entityCollection(ODataRequestResultGeneric result, CdsStructuredType resultType, ODataProtocol protocol) {
        return ODataDataUtils.normalize(ODataDataUtils.preciseNumbers(result).asListOfMaps(), resultType, protocol);
    }

    public static Object operation(ODataRequestResultGeneric result, CdsType targetType, ODataProtocol protocol, String operationName) {
        result = ODataDataUtils.preciseNumbers(result);
        if (ODataTypeUtils.isStructuredType(targetType)) {
            CdsStructuredType type = (CdsStructuredType)targetType.as(CdsStructuredType.class);
            Map mapResult = result.asMap();
            if (mapResult.size() == 1 && mapResult.containsKey(operationName)) {
                mapResult = (Map)mapResult.get(operationName);
            }
            return ODataTypeUtils.toCdsTypes(type, ODataDataUtils.normalize(mapResult, type, protocol));
        }
        if (ODataTypeUtils.isArrayedStruturedType(targetType)) {
            CdsStructuredType type = (CdsStructuredType)((CdsArrayedType)targetType.as(CdsArrayedType.class)).getItemsType().as(CdsStructuredType.class);
            return ODataTypeUtils.toCdsTypes(type, ODataDataUtils.normalize(result.asListOfMaps(), type, protocol));
        }
        if (ODataTypeUtils.isSimpleType(targetType)) {
            if (protocol == ODataProtocol.V2) {
                return ODataTypeUtils.toCdsType(result.asMap().get(operationName), ((CdsSimpleType)targetType.as(CdsSimpleType.class)).getType());
            }
            return ODataTypeUtils.toCdsType(result.asMap().get(ODATA_V2_VALUE), ((CdsSimpleType)targetType.as(CdsSimpleType.class)).getType());
        }
        if (ODataTypeUtils.isArrayedSimpleType(targetType)) {
            CdsBaseType type = ((CdsSimpleType)((CdsArrayedType)targetType.as(CdsArrayedType.class)).getItemsType().as(CdsSimpleType.class)).getType();
            if (protocol == ODataProtocol.V2) {
                return ODataTypeUtils.toCdsTypes(type, (Iterable)result.asMap().get(ODATA_V2_RESULTS));
            }
            return ODataTypeUtils.toCdsTypes(type, (Iterable)result.asMap().get(ODATA_V2_VALUE));
        }
        return result;
    }

    public static void clean(List<Map<String, Object>> entryData, CdsStructuredType entryType) {
        DataProcessor.create().bulkAction((type, entries) -> {
            Set elements = type.elements().map(CdsElement::getName).collect(Collectors.toSet());
            entries.forEach(entry -> entry.entrySet().removeIf(e -> !elements.contains(e.getKey())));
        }).process(entryData, entryType);
    }

    @VisibleForTesting
    static Map<String, Object> normalize(Map<String, Object> data, CdsStructuredType dataType, ODataProtocol protocol) {
        return ODataDataUtils.normalize(Arrays.asList(data), dataType, protocol).get(0);
    }

    @VisibleForTesting
    static List<Map<String, Object>> normalize(List<Map<String, Object>> data, CdsStructuredType dataType, ODataProtocol protocol) {
        DataProcessor.create().action((currentStructType, row) -> {
            for (String key : new HashSet(row.keySet())) {
                Optional element = currentStructType.findElement(key);
                if (element.isPresent()) {
                    CdsType elementType = ((CdsElement)element.get()).getType();
                    if (protocol != ODataProtocol.V2 || !elementType.isAssociation() || !(row.get(key) instanceof Map)) continue;
                    Map assocValue = (Map)row.get(key);
                    if (CdsModelUtils.isSingleValued((CdsType)elementType)) {
                        CdsEntity assocTarget = ((CdsAssociationType)elementType.as(CdsAssociationType.class)).getTarget();
                        if (assocValue.isEmpty() || assocValue.keySet().stream().anyMatch(arg_0 -> ODataDataUtils.lambda$normalize$4((CdsStructuredType)assocTarget, arg_0))) continue;
                        row.put(key, null);
                        continue;
                    }
                    row.put(key, assocValue.get(ODATA_V2_RESULTS));
                    continue;
                }
                row.remove(key);
            }
        }).process(data, dataType);
        return data;
    }

    private static ODataRequestResultGeneric preciseNumbers(ODataRequestResultGeneric result) {
        return result.withNumberDeserializationStrategy(NumberDeserializationStrategy.BIG_DECIMAL);
    }

    private static /* synthetic */ boolean lambda$normalize$4(CdsStructuredType assocTarget, Object k) {
        return assocTarget.elements().anyMatch(e -> Objects.equals(e.getName(), k));
    }
}

