/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SelectGenerator
implements AbstractGenerator,
CqnVisitor {
    private final CdsEntity target;
    private final ConversionContext context;
    private final Set<String> selected = new LinkedHashSet<String>();
    private final Set<String> expanded = new LinkedHashSet<String>();
    private final Set<String> excluded = new HashSet<String>();
    private boolean hasStar = false;

    public SelectGenerator(CdsEntity target, ConversionContext context) {
        this.target = target;
        this.context = context;
    }

    public SelectGenerator(CdsEntity target, ConversionContext context, CqnSelect select) {
        this(target, context);
        this.excluded.addAll(select.excluding());
    }

    public void visit(CqnStar star) {
        this.hasStar = true;
    }

    public void visit(CqnSelectListValue slv) {
        if (slv.value().isRef()) {
            CqnElementRef ref = slv.value().asRef();
            if (ref.size() == 1) {
                String element = ref.firstSegment();
                this.selected.add(element);
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_PATH_EXPR, new Object[0]);
            }
        }
    }

    public void visit(CqnExpand expand) {
        CqnStructuredTypeRef ref = expand.ref();
        if (ref.size() != 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_PATH_EXPR, new Object[0]);
        }
        if (this.context.getProtocol() == ODataProtocol.V2 && CqnStatementUtils.isSelectStar((List)expand.items())) {
            this.selected.add(ref.firstSegment());
        } else if (this.context.getProtocol() == ODataProtocol.V4) {
            this.expanded.add(ref.firstSegment());
        }
    }

    @Override
    public void apply(StructuredQuery query) {
        block12: {
            block9: {
                block11: {
                    block10: {
                        if (this.excluded.isEmpty()) break block9;
                        if (this.hasStar) break block10;
                        if (!this.selected.isEmpty()) break block11;
                    }
                    this.target.elements().filter(e -> e.findAnnotation("odata.foreignKey4").map(CdsAnnotation::getValue).map(v -> !this.excluded.contains(v)).orElse(true)).map(e -> e.getName()).forEach(this.selected::add);
                }
                this.selected.removeAll(this.excluded);
                if (this.selected.isEmpty()) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_EMPTY_SELECTION, new Object[0]);
                }
                break block12;
            }
            if (this.context.getProtocol() == ODataProtocol.V2 && this.hasStar && query.isRoot()) {
                this.selected.add("*");
            } else if (this.context.getProtocol() == ODataProtocol.V4 && !this.hasStar && this.selected.isEmpty() && !this.expanded.isEmpty()) {
                this.selected.addAll(this.expanded);
            }
        }
        if (this.selected.size() > 0) {
            query.select(this.selected.toArray(new String[this.selected.size()]));
        }
    }
}

