/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.odata.serialization.ODataJsonSerializer;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

class ODataV4JsonSerializer
implements ODataJsonSerializer {
    private static ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS).registerModule((Module)new SimpleModule().addSerializer((JsonSerializer)new InstantSerializer(Instant.class)).addSerializer((JsonSerializer)new LocalDateSerializer(LocalDate.class)).addSerializer((JsonSerializer)new LocalTimeSerializer(LocalTime.class)));

    ODataV4JsonSerializer() {
    }

    @Override
    public String serialize(Map<String, Object> row) {
        try {
            return mapper.writeValueAsString(row);
        }
        catch (JsonProcessingException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_JSON_SERIALIZATION, new Object[]{e});
        }
    }

    private static class InstantSerializer
    extends StdSerializer<Instant> {
        private static final long serialVersionUID = 1L;

        public InstantSerializer(Class<Instant> t) {
            super(t);
        }

        public void serialize(Instant instant, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(DateTimeFormatter.ISO_INSTANT.format(instant));
        }
    }

    private static class LocalDateSerializer
    extends StdSerializer<LocalDate> {
        private static final long serialVersionUID = 1L;

        public LocalDateSerializer(Class<LocalDate> t) {
            super(t);
        }

        public void serialize(LocalDate localDate, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(DateTimeFormatter.ISO_DATE.format(localDate));
        }
    }

    private static class LocalTimeSerializer
    extends StdSerializer<LocalTime> {
        private static final long serialVersionUID = 1L;

        public LocalTimeSerializer(Class<LocalTime> t) {
            super(t);
        }

        public void serialize(LocalTime localTime, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(DateTimeFormatter.ISO_TIME.format(localTime));
        }
    }
}

