/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.uri;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.impl.odata.utils.CqnToCloudSdkConverter;
import com.sap.cds.services.impl.odata.utils.ODataTypeUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.AbstractODataParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UriGenerator {
    private final CqnAnalyzer analyzer;
    private final ConversionContext context;
    private final boolean operation;
    private boolean collection = true;

    public UriGenerator(ConversionContext context) {
        this(context, false);
    }

    public UriGenerator(ConversionContext context, boolean operation) {
        this.analyzer = CqnAnalyzer.create((CdsModel)context.getEventContext().getModel());
        this.context = context;
        this.operation = operation;
    }

    public ODataResourcePath analyze(CqnStatement statement) {
        return this.analyze(statement, Collections.emptyMap());
    }

    public ODataResourcePath analyze(CqnStatement statement, Map<String, Object> data) {
        if (statement == null) {
            return new ODataResourcePath();
        }
        if (statement.isUpdate()) {
            return this.interpretAnalysis(this.analyzer.analyze(statement.asUpdate()), data, statement.asUpdate().where().isPresent());
        }
        if (statement.isDelete()) {
            return this.interpretAnalysis(this.analyzer.analyze(statement.asDelete()), data, statement.asDelete().where().isPresent());
        }
        if (statement.isSelect() && this.operation) {
            return this.interpretAnalysis(this.analyzer.analyze(statement.asSelect()), data, statement.asSelect().where().isPresent());
        }
        return this.interpretAnalysis(this.analyzer.analyze(statement.ref()), data, false);
    }

    private ODataResourcePath interpretAnalysis(AnalysisResult analysis, Map<String, Object> data, boolean where) {
        ODataResourcePath uri = new ODataResourcePath();
        Iterator iterator = analysis.iterator();
        CdsEntity previous = null;
        while (iterator.hasNext()) {
            Map keys;
            boolean isTarget;
            ResolvedSegment segment = (ResolvedSegment)iterator.next();
            if (previous == null) {
                uri.addSegment(segment.entity().getName());
                previous = segment.entity();
            } else {
                String navigationProperty = segment.segment().id();
                uri.addSegment(navigationProperty);
                this.collection = !CdsModelUtils.isSingleValued((CdsType)previous.getAssociation(navigationProperty).getType());
                previous = (CdsEntity)previous.getTargetOf(navigationProperty);
            }
            boolean bl = isTarget = !iterator.hasNext();
            if (!segment.segment().filter().isPresent() && (!isTarget || !where && data.isEmpty())) continue;
            Map map = keys = isTarget && where ? analysis.targetKeyValues() : segment.keyValues();
            if (isTarget && !data.isEmpty()) {
                segment.entity().keyElements().map(CdsElementDefinition::getName).filter(k -> !keys.containsKey(k)).filter(data::containsKey).forEach(k -> keys.put(k, data.get(k)));
            }
            if ((long)keys.size() < segment.entity().keyElements().count()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_INCOMPLETE_KEY, new Object[]{segment.entity().getQualifiedName()});
            }
            uri.addParameterToLastSegment((AbstractODataParameters)ODataEntityKey.of(this.convertToCloudSdkTypedKeys(keys, segment.entity()), (ODataProtocol)this.context.getProtocol()));
            this.collection = false;
        }
        return uri;
    }

    private Map<String, Object> convertToCloudSdkTypedKeys(Map<String, Object> keys, CdsEntity entity) {
        HashMap<String, Object> cloudSdkTypedKeys = new HashMap<String, Object>();
        for (Map.Entry<String, Object> keyEntry : keys.entrySet()) {
            CdsBaseType keyType = ODataTypeUtils.getCdsType((CdsStructuredType)entity, (CqnElementRef)CQL.get((String)keyEntry.getKey()));
            cloudSdkTypedKeys.put(keyEntry.getKey(), CqnToCloudSdkConverter.convert(keyEntry.getValue(), (CdsStructuredType)entity, keyType, this.context));
        }
        return cloudSdkTypedKeys;
    }

    public boolean isCollection() {
        return this.collection;
    }
}

