/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.utils;

import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.impl.odata.utils.ExtendedMatchesPattern;
import com.sap.cds.services.impl.odata.utils.ODataTypeUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FieldReference;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FieldUntyped;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpressionArithmetic;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpressionString;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpressionTemporal;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBoolean;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDate;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDateTimeOffset;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueNumeric;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueString;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueTimeOfDay;
import java.time.Instant;
import java.util.Locale;

public class CqnToCloudSdkConverter {
    private final Object left;
    private final Object right;
    private final CdsStructuredType structType;
    private final ConversionContext context;
    private Expressions.OperandSingle operandLeft;
    private Expressions.OperandSingle operandRight;
    private CdsBaseType type = null;

    public CqnToCloudSdkConverter(Object left, Object right, CdsStructuredType structType, ConversionContext context) {
        this.left = left;
        this.right = right;
        this.structType = structType;
        this.context = context;
    }

    public void convert() {
        this.operandLeft = this.toOperand(this.left, this.type);
        this.operandRight = this.toOperand(this.right, this.type);
        if (this.operandLeft == null) {
            this.operandLeft = this.toOperand(this.left, this.type, false);
        }
        if (this.operandRight == null) {
            this.operandRight = this.toOperand(this.right, this.type, false);
        }
    }

    public Expressions.OperandSingle getLeft() {
        return this.operandLeft;
    }

    public Expressions.OperandSingle getRight() {
        return this.operandRight;
    }

    public static Expressions.OperandSingle convert(Object obj, CdsStructuredType structType, ConversionContext context) {
        CqnToCloudSdkConverter converter = new CqnToCloudSdkConverter(obj, null, structType, context);
        converter.convert();
        return converter.getLeft();
    }

    public static Expressions.OperandSingle convert(Object obj, CdsStructuredType structType, CdsBaseType type, ConversionContext context) {
        CqnToCloudSdkConverter converter = new CqnToCloudSdkConverter(obj, null, structType, context);
        converter.setType(type);
        converter.convert();
        return converter.getLeft();
    }

    public static Expressions.OperandSingle convert(Object obj, CdsStructuredType structType, CqnValue element, ConversionContext context) {
        CqnToCloudSdkConverter converter = new CqnToCloudSdkConverter(element, obj, structType, context);
        converter.convert();
        return converter.getRight();
    }

    private Expressions.OperandSingle toFunction(CqnFunc func) {
        ODataProtocol protocol = this.context.getProtocol();
        try {
            switch (func.func().toLowerCase(Locale.US)) {
                case "contains": {
                    this.setType(CdsBaseType.BOOLEAN);
                    if (protocol == ODataProtocol.V2) {
                        return FilterExpressionString.substringOf((ValueString)this.toValueString((CqnValue)func.args().get(1)), (ValueString)this.toValueString((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionString.contains((ValueString)this.toValueString((CqnValue)func.args().get(0)), (ValueString)this.toValueString((CqnValue)func.args().get(1)));
                }
                case "endswith": {
                    this.setType(CdsBaseType.BOOLEAN);
                    return FilterExpressionString.endsWith((ValueString)this.toValueString((CqnValue)func.args().get(0)), (ValueString)this.toValueString((CqnValue)func.args().get(1)));
                }
                case "startswith": {
                    this.setType(CdsBaseType.BOOLEAN);
                    return FilterExpressionString.startsWith((ValueString)this.toValueString((CqnValue)func.args().get(0)), (ValueString)this.toValueString((CqnValue)func.args().get(1)));
                }
                case "length": {
                    this.setType(CdsBaseType.INTEGER);
                    return FilterExpressionString.length((ValueString)this.toValueString((CqnValue)func.args().get(0)));
                }
                case "indexof": {
                    this.setType(CdsBaseType.INTEGER);
                    return FilterExpressionString.indexOf((ValueString)this.toValueString((CqnValue)func.args().get(0)), (ValueString)this.toValueString((CqnValue)func.args().get(1)));
                }
                case "substring": {
                    this.setType(CdsBaseType.STRING);
                    return FilterExpressionString.substring((ValueString)this.toValueString((CqnValue)func.args().get(0)), (ValueNumeric)this.toValueNumeric((CqnValue)func.args().get(1)));
                }
                case "tolower": {
                    this.setType(CdsBaseType.STRING);
                    return FilterExpressionString.toLower((ValueString)this.toValueString((CqnValue)func.args().get(0)));
                }
                case "toupper": {
                    this.setType(CdsBaseType.STRING);
                    return FilterExpressionString.toUpper((ValueString)this.toValueString((CqnValue)func.args().get(0)));
                }
                case "trim": {
                    this.setType(CdsBaseType.STRING);
                    return FilterExpressionString.trim((ValueString)this.toValueString((CqnValue)func.args().get(0)));
                }
                case "concat": {
                    this.setType(CdsBaseType.STRING);
                    return FilterExpressionString.concat((ValueString)this.toValueString((CqnValue)func.args().get(0)), (ValueString)this.toValueString((CqnValue)func.args().get(1)));
                }
                case "matchespattern": {
                    return this.toMatchesPattern(func, protocol);
                }
                case "year": {
                    this.setType(CdsBaseType.INTEGER);
                    if (CqnToCloudSdkConverter.isInstant((CqnValue)func.args().get(0))) {
                        return FilterExpressionTemporal.year((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionTemporal.year((ValueDate)this.toValueDate((CqnValue)func.args().get(0)));
                }
                case "month": {
                    this.setType(CdsBaseType.INTEGER);
                    if (CqnToCloudSdkConverter.isInstant((CqnValue)func.args().get(0))) {
                        return FilterExpressionTemporal.month((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionTemporal.month((ValueDate)this.toValueDate((CqnValue)func.args().get(0)));
                }
                case "day": {
                    this.setType(CdsBaseType.INTEGER);
                    if (CqnToCloudSdkConverter.isInstant((CqnValue)func.args().get(0))) {
                        return FilterExpressionTemporal.day((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionTemporal.day((ValueDate)this.toValueDate((CqnValue)func.args().get(0)));
                }
                case "hour": {
                    this.setType(CdsBaseType.INTEGER);
                    if (CqnToCloudSdkConverter.isInstant((CqnValue)func.args().get(0))) {
                        return FilterExpressionTemporal.hour((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionTemporal.hour((ValueTimeOfDay)this.toValueTimeOfDay((CqnValue)func.args().get(0)));
                }
                case "minute": {
                    this.setType(CdsBaseType.INTEGER);
                    if (CqnToCloudSdkConverter.isInstant((CqnValue)func.args().get(0))) {
                        return FilterExpressionTemporal.minute((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionTemporal.minute((ValueTimeOfDay)this.toValueTimeOfDay((CqnValue)func.args().get(0)));
                }
                case "second": {
                    this.setType(CdsBaseType.INTEGER);
                    if (CqnToCloudSdkConverter.isInstant((CqnValue)func.args().get(0))) {
                        return FilterExpressionTemporal.second((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionTemporal.second((ValueTimeOfDay)this.toValueTimeOfDay((CqnValue)func.args().get(0)));
                }
                case "fractionalseconds": {
                    if (protocol == ODataProtocol.V2) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
                    }
                    this.setType(CdsBaseType.INTEGER);
                    if (CqnToCloudSdkConverter.isInstant((CqnValue)func.args().get(0))) {
                        return FilterExpressionTemporal.fractionalSeconds((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                    }
                    return FilterExpressionTemporal.fractionalSeconds((ValueTimeOfDay)this.toValueTimeOfDay((CqnValue)func.args().get(0)));
                }
                case "date": {
                    if (protocol == ODataProtocol.V2) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
                    }
                    this.setType(CdsBaseType.DATE);
                    return FilterExpressionTemporal.date((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                }
                case "time": {
                    if (protocol == ODataProtocol.V2) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
                    }
                    this.setType(CdsBaseType.DATE);
                    return FilterExpressionTemporal.time((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                }
                case "totaloffsetminutes": {
                    if (protocol == ODataProtocol.V2) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
                    }
                    this.setType(CdsBaseType.INTEGER);
                    return FilterExpressionTemporal.totalOffsetMinutes((ValueDateTimeOffset)this.toValueDateTimeOffset((CqnValue)func.args().get(0)));
                }
                case "now": {
                    if (protocol == ODataProtocol.V2) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
                    }
                    this.setType(CdsBaseType.TIMESTAMP);
                    return FilterExpressionTemporal.now();
                }
                case "mindatetime": {
                    if (protocol == ODataProtocol.V2) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
                    }
                    this.setType(CdsBaseType.TIMESTAMP);
                    return FilterExpressionTemporal.minDateTime();
                }
                case "maxdatetime": {
                    if (protocol == ODataProtocol.V2) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
                    }
                    this.setType(CdsBaseType.TIMESTAMP);
                    return FilterExpressionTemporal.maxDateTime();
                }
                case "round": {
                    this.setType(CdsBaseType.INTEGER);
                    return FilterExpressionArithmetic.round((ValueNumeric)this.toValueNumeric((CqnValue)func.args().get(0)));
                }
                case "floor": {
                    this.setType(CdsBaseType.INTEGER);
                    return FilterExpressionArithmetic.floor((ValueNumeric)this.toValueNumeric((CqnValue)func.args().get(0)));
                }
                case "ceiling": {
                    this.setType(CdsBaseType.INTEGER);
                    return FilterExpressionArithmetic.ceiling((ValueNumeric)this.toValueNumeric((CqnValue)func.args().get(0)));
                }
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION, new Object[]{func.func()});
        }
        catch (IndexOutOfBoundsException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_NUM_ARGS, new Object[]{func.func(), e});
        }
    }

    private ValueString toValueString(CqnValue value) {
        Expressions.OperandSingle result = this.toOperand(value, CdsBaseType.STRING);
        if (result instanceof FieldUntyped) {
            FieldUntyped untyped = (FieldUntyped)result;
            return untyped.asString();
        }
        return (ValueString)result;
    }

    private ValueNumeric toValueNumeric(CqnValue value) {
        Expressions.OperandSingle result = this.toOperand(value, null, false);
        if (result instanceof FieldUntyped) {
            FieldUntyped untyped = (FieldUntyped)result;
            return untyped.asNumber();
        }
        return (ValueNumeric)result;
    }

    private ValueDate toValueDate(CqnValue value) {
        Expressions.OperandSingle result = this.toOperand(value, CdsBaseType.DATE);
        if (result instanceof FieldUntyped) {
            FieldUntyped untyped = (FieldUntyped)result;
            return untyped.asDate();
        }
        return (ValueDate)result;
    }

    private ValueDateTimeOffset toValueDateTimeOffset(CqnValue value) {
        Expressions.OperandSingle result = this.toOperand(value, CdsBaseType.TIMESTAMP);
        if (result instanceof FieldUntyped) {
            FieldUntyped untyped = (FieldUntyped)result;
            return untyped.asDateTimeOffset();
        }
        return (ValueDateTimeOffset)result;
    }

    private ValueTimeOfDay toValueTimeOfDay(CqnValue value) {
        Expressions.OperandSingle result = this.toOperand(value, CdsBaseType.TIME);
        if (result instanceof FieldUntyped) {
            FieldUntyped untyped = (FieldUntyped)result;
            return untyped.asTimeOfDay();
        }
        return (ValueTimeOfDay)result;
    }

    private Expressions.OperandSingle toOdataLiteral(Object obj, CdsBaseType type) {
        ODataProtocol protocol = this.context.getProtocol();
        return Expressions.createOperand((Object)ODataTypeUtils.toCloudSdkType(obj, type, protocol));
    }

    private Expressions.OperandSingle handleRef(CqnElementRef ref) {
        EventContext eventContext = this.context.getEventContext();
        if (ref.firstSegment().equals("$now") && ref.size() == 1) {
            this.setType(CdsBaseType.TIMESTAMP);
            return this.toOdataLiteral(Instant.now(), this.type);
        }
        if (ref.size() == 2) {
            if ("$valid".equals(ref.firstSegment()) || "$at".equals(ref.firstSegment())) {
                if (ref.lastSegment().equals("from")) {
                    this.setType(CdsBaseType.TIMESTAMP);
                    return this.toOdataLiteral(eventContext.getParameterInfo().getValidFrom(), this.type);
                }
                if (ref.lastSegment().equals("to")) {
                    this.setType(CdsBaseType.TIMESTAMP);
                    return this.toOdataLiteral(eventContext.getParameterInfo().getValidTo(), this.type);
                }
            }
            if (ref.firstSegment().equals("$user")) {
                if (ref.lastSegment().equals("locale")) {
                    this.setType(CdsBaseType.STRING);
                    return this.toOdataLiteral(LocaleUtils.getLocaleString((Locale)eventContext.getParameterInfo().getLocale()), this.type);
                }
                if (ref.lastSegment().equals("id")) {
                    this.setType(CdsBaseType.STRING);
                    return this.toOdataLiteral(eventContext.getUserInfo().getName(), this.type);
                }
            }
        }
        if (ref.firstSegment().equals("$key") && ref.size() == 1 && this.structType.keyElements().count() == 1L) {
            ref = CQL.get((String)((CdsElement)this.structType.keyElements().findFirst().get()).getName());
        }
        this.setType(ODataTypeUtils.getCdsType(this.structType, ref));
        return CqnToCloudSdkConverter.convertRefToFieldUntyped((CqnReference)ref);
    }

    private Expressions.OperandSingle handleParameter(CqnParameter parameter) {
        Object parameterValue = this.context.getParameterValue(parameter);
        return CqnToCloudSdkConverter.convert(parameterValue, this.structType, this.type, this.context);
    }

    private Expressions.OperandSingle odataNull() {
        return (arg_0, arg_1) -> ((Expressions.Operand)Expressions.Operand.NULL).getExpression(arg_0, arg_1);
    }

    private Expressions.OperandSingle toOperand(Object obj, CdsBaseType type) {
        return this.toOperand(obj, type, true);
    }

    private Expressions.OperandSingle toOperand(Object obj, CdsBaseType type, boolean requireType) {
        if (obj == null) {
            return this.odataNull();
        }
        if (obj instanceof CqnValue) {
            CqnValue value = (CqnValue)obj;
            if (value.isRef()) {
                return this.handleRef(value.asRef());
            }
            if (value.isFunction()) {
                return this.toFunction(value.asFunction());
            }
            if (value.isLiteral() && (type != null || !requireType)) {
                return this.toOdataLiteral(value.asLiteral().value(), type);
            }
            if (value.isNullValue()) {
                return this.odataNull();
            }
            if (value.isParameter()) {
                return this.handleParameter(value.asParameter());
            }
        } else {
            return this.toOdataLiteral(obj, type);
        }
        return null;
    }

    private void setType(CdsBaseType type) {
        if (this.type == null) {
            this.type = type;
        }
    }

    public static FieldUntyped convertRefToFieldUntyped(CqnReference ref) {
        return FieldReference.ofPath((String[])((String[])ref.segments().stream().map(s -> s.id()).toArray(String[]::new)));
    }

    private static boolean isInstant(CqnValue value) {
        return value.isLiteral() && value.asLiteral().value() instanceof Instant;
    }

    private ValueBoolean toMatchesPattern(CqnFunc func, ODataProtocol protocol) {
        if (protocol == ODataProtocol.V2) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_FUNCTION_VERSION, new Object[]{func.func(), protocol});
        }
        this.setType(CdsBaseType.STRING);
        if (func.args().size() > 2 && !((String)((CqnValue)func.args().get(2)).asLiteral().asString().value()).isBlank()) {
            return new ExtendedMatchesPattern(((CqnValue)func.args().get(0)).asRef(), (CqnValue)func.args().get(1), (CqnValue)func.args().get(2));
        }
        return this.toValueString((CqnValue)func.args().get(0)).matches(this.toValueString((CqnValue)func.args().get(1)));
    }
}

