/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.utils;

import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsTypeUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

public class ODataTypeUtils {
    public static final long FACTOR_MILLIS_TO_DAYS = 86400000L;

    public static Object toCloudSdkType(Object value, CdsBaseType type, ODataProtocol protocol) {
        if (value == null) {
            return null;
        }
        if (type != null) {
            switch (type) {
                case UUID: {
                    return UUID.fromString((String)value);
                }
                case STRING: {
                    return value.toString();
                }
            }
        }
        if (protocol == ODataProtocol.V2 && value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        return value;
    }

    public static CdsBaseType getCdsType(CdsStructuredType structuredType, CqnElementRef ref) {
        CdsElement element = null;
        for (CqnReference.Segment segment : ref.segments()) {
            element = structuredType.getElement(segment.id());
            if (!element.getType().isAssociation()) continue;
            structuredType = structuredType.getTargetOf(element.getName());
        }
        if (element != null) {
            if (element.getType().isSimple()) {
                return ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType();
            }
            if (element.getType().isArrayed()) {
                CdsType type = element.getType();
                while (type.isArrayed()) {
                    type = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
                }
                if (type.isSimple()) {
                    return ((CdsSimpleType)type.as(CdsSimpleType.class)).getType();
                }
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_REF_TYPE, new Object[]{ref.path(), structuredType.getQualifiedName()});
    }

    public static <T extends Map<String, Object>> T toCdsTypes(CdsStructuredType structuredType, T data) {
        return (T)ODataTypeUtils.toCdsTypes(structuredType, Arrays.asList(data)).get(0);
    }

    public static <T extends Iterable<? extends Map<String, Object>>> T toCdsTypes(CdsStructuredType structuredType, T data) {
        DataProcessor.create().action((currentStructType, row) -> {
            for (String key : new HashSet(row.keySet())) {
                CdsType elementType;
                Optional element = currentStructType.findElement(key);
                if (!element.isPresent() || !(elementType = ((CdsElement)element.get()).getType()).isSimple()) continue;
                row.put(key, ODataTypeUtils.toCdsType(row.get(key), ((CdsSimpleType)elementType.as(CdsSimpleType.class)).getType()));
            }
        }).process(data, structuredType);
        return data;
    }

    public static Iterable<?> toCdsTypes(CdsBaseType type, Iterable<? extends Object> data) {
        ArrayList result = new ArrayList();
        data.forEach(e -> result.add(ODataTypeUtils.toCdsType(e, type)));
        return result;
    }

    public static Object toCdsType(Object value, CdsBaseType type) {
        if (value == null) {
            return value;
        }
        try {
            if (type.javaType().isInstance(value)) {
                return value;
            }
            switch (type) {
                case DECIMAL: 
                case DECIMAL_FLOAT: {
                    if (value instanceof Double || value instanceof Float) {
                        return new BigDecimal(ODataTypeUtils.handlePrimitiveTypesDouble(value));
                    }
                    if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                        return new BigDecimal(ODataTypeUtils.handlePrimitiveTypesLong(value));
                    }
                    if (!(value instanceof BigInteger)) break;
                    BigInteger integer = (BigInteger)value;
                    return new BigDecimal(integer);
                }
                case DOUBLE: {
                    if (value instanceof BigDecimal) {
                        BigDecimal decimal = (BigDecimal)value;
                        return decimal.doubleValue();
                    }
                    if (value instanceof BigInteger) {
                        BigInteger integer = (BigInteger)value;
                        return integer.doubleValue();
                    }
                    if (!(value instanceof Number)) break;
                    return ODataTypeUtils.handlePrimitiveTypesDouble(value);
                }
                case INTEGER: {
                    if (value instanceof BigDecimal) {
                        BigDecimal decimal = (BigDecimal)value;
                        return decimal.intValue();
                    }
                    if (value instanceof BigInteger) {
                        BigInteger integer = (BigInteger)value;
                        return integer.intValue();
                    }
                    if (!(value instanceof Number)) break;
                    return (int)ODataTypeUtils.handlePrimitiveTypesLong(value);
                }
                case INTEGER64: {
                    if (value instanceof BigDecimal) {
                        BigDecimal decimal = (BigDecimal)value;
                        return decimal.longValue();
                    }
                    if (value instanceof BigInteger) {
                        BigInteger integer = (BigInteger)value;
                        return integer.longValue();
                    }
                    if (!(value instanceof Number)) break;
                    return ODataTypeUtils.handlePrimitiveTypesLong(value);
                }
                case DATETIME: 
                case TIMESTAMP: {
                    if (value instanceof LocalDateTime) {
                        LocalDateTime time = (LocalDateTime)value;
                        return time.toInstant(ZoneOffset.UTC);
                    }
                    if (value instanceof OffsetDateTime) {
                        OffsetDateTime time = (OffsetDateTime)value;
                        return time.toInstant();
                    }
                    if (value instanceof LocalDate) {
                        LocalDate date = (LocalDate)value;
                        return date.atStartOfDay().toInstant(ZoneOffset.UTC);
                    }
                    if (!ODataTypeUtils.isJsDate(value)) break;
                    return Instant.ofEpochMilli(ODataTypeUtils.jsDateToEpochMillis((String)value));
                }
                case DATE: {
                    if (value instanceof LocalDateTime) {
                        LocalDateTime time = (LocalDateTime)value;
                        return time.toLocalDate();
                    }
                    if (value instanceof OffsetDateTime) {
                        OffsetDateTime time = (OffsetDateTime)value;
                        return time.toLocalDate();
                    }
                    if (!ODataTypeUtils.isJsDate(value)) break;
                    long epochMillis = ODataTypeUtils.jsDateToEpochMillis((String)value);
                    return LocalDate.ofEpochDay(epochMillis / 86400000L);
                }
                case TIME: {
                    String string;
                    if (value instanceof LocalDateTime) {
                        LocalDateTime time = (LocalDateTime)value;
                        return time.toLocalTime();
                    }
                    if (value instanceof OffsetDateTime) {
                        OffsetDateTime time = (OffsetDateTime)value;
                        return time.toLocalTime();
                    }
                    if (!(value instanceof String) || !(string = (String)value).startsWith("P")) break;
                    Duration duration = Duration.parse(string);
                    return LocalTime.of(0, 0).plus(duration);
                }
                case UUID: {
                    if (!(value instanceof UUID)) break;
                    return value.toString();
                }
                case STRING: 
                case LARGE_STRING: {
                    return value.toString();
                }
                case BINARY: 
                case LARGE_BINARY: {
                    if (!(value instanceof String)) break;
                    String string = (String)value;
                    return Base64.decodeBase64((String)string);
                }
            }
            return CdsTypeUtils.parse((CdsBaseType)type, (String)value.toString());
        }
        catch (CdsDataException | ClassCastException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_TYPE_CONV, new Object[]{value, value.getClass(), type, e});
        }
    }

    private static boolean isJsDate(Object value) {
        String s;
        return value instanceof String && (s = (String)value).startsWith("/Date(");
    }

    private static long jsDateToEpochMillis(String jsDate) {
        String time = jsDate.substring(6, jsDate.length() - 2);
        int zoneStart = time.lastIndexOf("+");
        if (zoneStart < 1) {
            zoneStart = time.lastIndexOf("-");
        }
        return Long.parseLong(time.substring(0, zoneStart > 0 ? zoneStart : time.length()));
    }

    private static long handlePrimitiveTypesLong(Object value) {
        if (value instanceof Byte) {
            Byte byte1 = (Byte)value;
            return byte1.longValue();
        }
        if (value instanceof Short) {
            Short short1 = (Short)value;
            return short1.longValue();
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer.longValue();
        }
        if (value instanceof Float) {
            Float float1 = (Float)value;
            return float1.longValue();
        }
        if (value instanceof Double) {
            Double double1 = (Double)value;
            return double1.longValue();
        }
        return (Long)value;
    }

    private static double handlePrimitiveTypesDouble(Object value) {
        if (value instanceof Byte) {
            Byte byte1 = (Byte)value;
            return byte1.doubleValue();
        }
        if (value instanceof Short) {
            Short short1 = (Short)value;
            return short1.doubleValue();
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer.doubleValue();
        }
        if (value instanceof Long) {
            Long long1 = (Long)value;
            return long1.doubleValue();
        }
        if (value instanceof Float) {
            Float float1 = (Float)value;
            return float1.doubleValue();
        }
        return (Double)value;
    }

    public static boolean isSimpleType(CdsType type) {
        return type != null && type.isSimple();
    }

    public static boolean isArrayedSimpleType(CdsType type) {
        return type != null && type.isArrayed() && ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().isSimple();
    }

    public static boolean isStructuredType(CdsType type) {
        return type != null && type.isStructured();
    }

    public static boolean isArrayedStructuredType(CdsType type) {
        return type != null && type.isArrayed() && ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().isStructured();
    }
}

