/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.odata;

import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class RemoteODataHandlerConfiguration implements CdsRuntimeConfiguration {

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		if(configurer.getCdsRuntime().getServiceCatalog().getServices(RemoteService.class).findAny().isPresent()) {
			configurer.eventHandler(new RemoteODataHandler());
		}
	}

}
