/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnEntitySelector;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;

public class SkipGenerator implements AbstractGenerator {

	private Long skip;
	
	public SkipGenerator(CqnEntitySelector selector) {
		if (selector.hasLimit() && selector.skip() > 0) {
			skip = selector.skip();
		}
	}

	@Override
	public void apply(StructuredQuery query) {
		if(skip != null) {
			query.skip(skip);
		}
	}

}
