/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnEntitySelector;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;

public class TopGenerator implements AbstractGenerator {
	
	private Long top;
	
	public TopGenerator(CqnEntitySelector selector) {
		if (selector.hasLimit()) {
			top = selector.top();
		}
	}

	@Override
	public void apply(StructuredQuery query) {
		if (top != null) {
			query.top(top);
		}
	}

}
