/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.odata.serialization;

import java.util.Map;

import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;

public interface ODataJsonSerializer {

	public static ODataJsonSerializer create(ODataProtocol protocol) {
		if(protocol == ODataProtocol.V2) {
			return new ODataV2JsonSerializer();
		}
		return new ODataV4JsonSerializer();
	}

	public String serialize(Map<String, Object> row);

}
