/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.odata.utils;

import java.util.Collections;
import java.util.Map;

import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.services.EventContext;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;

public class ConversionContext {

	private final Map<String, Object> cqnNamedValues;
	private final ODataProtocol protocol;
	private final EventContext context;
	private int nextPositionalParameter = 0;

	public ConversionContext(Map<String, Object> cqnNamedValues, ODataProtocol protocol, EventContext context) {
		this.cqnNamedValues = cqnNamedValues;
		this.protocol = protocol;
		this.context = context;
	}

	public ConversionContext(ODataProtocol protocol, EventContext context) {
		this.cqnNamedValues = Collections.emptyMap();
		this.protocol = protocol;
		this.context = context;
	}

	public Object getParameterValue(CqnParameter parameter) {
		// handling of positional parameters is not really clear -> requires a defined order in which the CQN is processed
		// CDS4j is planning to deprecate them anyways, so we accept a "shaky" implementation here
		// -> works at least well with exactly one positional parameter
		String key = parameter.isPositional() ? String.valueOf(nextPositionalParameter++) : parameter.name();
		return cqnNamedValues.get(key);
	}

	public ODataProtocol getProtocol() {
		return protocol;
	}

	public EventContext getEventContext() {
		return context;
	}

}
