/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.odata.utils;

import java.util.Map;
import java.util.function.Predicate;

import javax.annotation.Nonnull;

import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FieldReference;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBoolean;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueString;


// Temporary replacement for proper implementation of matchesPattern function by CloudSDK
// with third argument for options/flags
class ExtendedMatchesPattern implements ValueBoolean {

	private static final String FUNCTION = "matchesPattern";
	private final CqnElementRef ref;
	private final CqnValue pattern;
	private final CqnValue options;

	ExtendedMatchesPattern(CqnElementRef ref, CqnValue pattern, CqnValue options) {
		this.ref = ref;
		this.pattern = pattern;
		this.options = options;
	}

	@Nonnull
	@Override
	public String getExpression(@Nonnull ODataProtocol protocol,
			@Nonnull Map<String, Predicate<FieldReference>> prefixes) {
		return "%s(%s,%s,%s)".formatted(FUNCTION,
				FieldReference.of(ref.displayName()).getExpression(protocol, prefixes),
				ValueString.literal(this.pattern.asLiteral().asString().value()).getExpression(protocol, prefixes),
				ValueString.literal(this.options.asLiteral().asString().value()).getExpression(protocol, prefixes));
	}
}
