/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnEntitySelector;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.impl.odata.query.ExpandGenerator;
import com.sap.cds.services.impl.odata.query.FilterGenerator;
import com.sap.cds.services.impl.odata.query.InlineCountGenerator;
import com.sap.cds.services.impl.odata.query.OrderByGenerator;
import com.sap.cds.services.impl.odata.query.SearchGenerator;
import com.sap.cds.services.impl.odata.query.SelectGenerator;
import com.sap.cds.services.impl.odata.query.SkipGenerator;
import com.sap.cds.services.impl.odata.query.TopGenerator;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.List;
import java.util.Optional;

public class StructuredQueryBuilder {
    private final ConversionContext context;
    private final CdsEntity target;
    private final StructuredQuery query;

    private StructuredQueryBuilder(ConversionContext context, CdsEntity targetEntity, StructuredQuery query) {
        this.context = context;
        this.target = targetEntity;
        this.query = query;
    }

    public static StructuredQueryBuilder forEntity(ConversionContext context, String entityName, CdsEntity targetEntity) {
        StructuredQuery q = StructuredQuery.onEntity((String)entityName, (ODataProtocol)context.getProtocol());
        return new StructuredQueryBuilder(context, targetEntity, q);
    }

    public static StructuredQueryBuilder forSubquery(ConversionContext context, String fieldName, CdsEntity targetEntity) {
        StructuredQuery q = StructuredQuery.asNestedQueryOnProperty((String)fieldName, (ODataProtocol)context.getProtocol());
        return new StructuredQueryBuilder(context, targetEntity, q);
    }

    public void skip(CqnEntitySelector selector) {
        this.apply(new SkipGenerator(selector));
    }

    public void top(CqnEntitySelector selector) {
        this.apply(new TopGenerator(selector));
    }

    public void orderBy(List<CqnSortSpecification> orderBy) {
        this.applyAll(orderBy, new OrderByGenerator(this.target, this.context));
    }

    public void filter(Optional<CqnPredicate> where) {
        where.ifPresent(w -> this.apply((CqnToken)w, new FilterGenerator(this.target, this.context)));
    }

    public void search(Optional<CqnPredicate> search) {
        search.ifPresent(w -> this.apply((CqnToken)w, new SearchGenerator(this.context)));
    }

    public void inlineCount(CqnSelect select) {
        this.apply(new InlineCountGenerator(this.context, select));
    }

    public void select(List<CqnSelectListItem> slis) {
        this.applyAll(slis, new SelectGenerator(this.target, this.context));
    }

    public void select(CqnSelect select) {
        SelectGenerator gen = new SelectGenerator(this.target, this.context, select);
        this.applyAll(select.items(), gen);
    }

    public void expand(List<CqnSelectListItem> slis) {
        this.applyAll(slis, new ExpandGenerator(this.target, this.context));
    }

    public void expand(CqnSelect select) {
        ExpandGenerator gen = new ExpandGenerator(this.target, this.context, select);
        this.applyAll(select.items(), gen);
    }

    public StructuredQuery build() {
        return this.query;
    }

    private void apply(AbstractGenerator gen) {
        gen.apply(this.query);
    }

    private <G extends AbstractGenerator & CqnVisitor> void apply(CqnToken t, G gen) {
        t.accept((CqnVisitor)gen);
        this.apply(gen);
    }

    private <G extends AbstractGenerator & CqnVisitor> void applyAll(Iterable<? extends CqnToken> tokens, G gen) {
        tokens.forEach(t -> t.accept((CqnVisitor)gen));
        this.apply(gen);
    }
}

