/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.transformation.CqnAncestorsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnDescendantsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnFilterTransformation;
import com.sap.cds.ql.cqn.transformation.CqnGroupByTransformation;
import com.sap.cds.ql.cqn.transformation.CqnHierarchySubsetTransformation;
import com.sap.cds.ql.cqn.transformation.CqnOrderByTransformation;
import com.sap.cds.ql.cqn.transformation.CqnSearchTransformation;
import com.sap.cds.ql.cqn.transformation.CqnSkipTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTopTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformationVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.impl.odata.query.FilterGenerator;
import com.sap.cds.services.impl.odata.query.OrderByGenerator;
import com.sap.cds.services.impl.odata.query.SearchGenerator;
import com.sap.cds.services.impl.odata.query.apply.TrafoFunc;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApplyGenerator
implements AbstractGenerator {
    private static final String SQ = "'";
    private static CharSequence TRAFO_DELIM = "/";
    private static ObjectMapper mapper = new ObjectMapper();
    private ConversionContext context;
    private CdsEntity entity;
    private CqnSelect select;
    private String path;

    public ApplyGenerator(CdsEntity entity, ConversionContext context, CqnSelect select, String encodedPathString) {
        this.context = context;
        this.entity = entity;
        this.select = select;
        this.path = encodedPathString;
    }

    @Override
    public void apply(StructuredQuery query) {
        if (!this.select.transformations().isEmpty()) {
            this.assertV4();
            String applyString = this.select.transformations().stream().map(t -> ApplyGenerator.toTrafoString(t, new TrafoVisitor())).collect(Collectors.joining(TRAFO_DELIM));
            query.withCustomParameter("$apply", applyString);
        }
    }

    private void assertV4() {
        ODataProtocol protocol = this.context.getProtocol();
        if (protocol != ODataProtocol.V4) {
            throw new ServiceException("$apply is not supported for %s", new Object[]{protocol});
        }
    }

    public static <T extends AbstractGenerator & CqnVisitor> String toExpressionString(T genVisitor, CqnToken token) {
        token.accept((CqnVisitor)genVisitor);
        return genVisitor.getExpression();
    }

    static String toTrafoString(CqnTransformation t, TrafoVisitor v) {
        t.accept((CqnTransformationVisitor)v);
        return v.getTrafoString();
    }

    private String resourcePath() {
        return "$root" + this.path;
    }

    private static String elRefToPath(CqnElementRef ref) {
        return ref.segments().stream().map(CqnReference.Segment::id).collect(Collectors.joining("/"));
    }

    private static String expandLevelsToJson(Map<Object, Long> expandLevels) {
        List<Map> nodes = expandLevels.entrySet().stream().map(e -> {
            HashMap<String, Object> m = new HashMap<String, Object>(2);
            m.put("NodeID", e.getKey());
            m.put("Levels", e.getValue());
            return m;
        }).toList();
        try {
            return mapper.writeValueAsString(nodes);
        }
        catch (JsonProcessingException e2) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_JSON_SERIALIZATION, new Object[]{e2});
        }
    }

    private static String sQuoteEncoded(String s) {
        return SQ + s.replace(SQ, "''") + SQ;
    }

    class TrafoVisitor
    implements CqnTransformationVisitor {
        private TrafoFunc trafo;

        TrafoVisitor() {
        }

        public String getTrafoString() {
            if (this.trafo == null) {
                throw new ServiceException("Unable to serialize $apply for remote consumption", new Object[0]);
            }
            return this.trafo.toString();
        }

        public void visit(CqnTopTransformation t) {
            this.trafo = TrafoFunc.create("top").value(t.top());
        }

        public void visit(CqnSkipTransformation s) {
            this.trafo = TrafoFunc.create("skip").value(s.skip());
        }

        public void visit(CqnOrderByTransformation o) {
            this.trafo = TrafoFunc.create("orderby").values(o.orderBy().stream().map(s -> ApplyGenerator.toExpressionString(new OrderByGenerator(ApplyGenerator.this.entity, ApplyGenerator.this.context), (CqnToken)s)).toList());
        }

        public void visit(CqnFilterTransformation f) {
            String filterExpr = ApplyGenerator.toExpressionString(new FilterGenerator(ApplyGenerator.this.entity, ApplyGenerator.this.context), (CqnToken)f.filter());
            this.trafo = TrafoFunc.create("filter").value(filterExpr);
        }

        public void visit(CqnSearchTransformation s) {
            String searchExpr = ApplyGenerator.toExpressionString(new SearchGenerator(ApplyGenerator.this.context), (CqnToken)s.search());
            this.trafo = TrafoFunc.create("search").value(searchExpr);
        }

        public void visit(CqnGroupByTransformation g) {
            this.trafo = TrafoFunc.create("groupby").values(g.dimensions().stream().map(el -> ApplyGenerator.elRefToPath(el)).toList());
        }

        public void visit(CqnTopLevelsTransformation t) {
            TrafoFunc f = TrafoFunc.create("com.sap.vocabularies.Hierarchy.v1.TopLevels").value("HierarchyNodes", ApplyGenerator.this.resourcePath()).value("HierarchyQualifier", ApplyGenerator.sQuoteEncoded(t.hierarchyQualifier())).value("NodeProperty", ApplyGenerator.sQuoteEncoded(ApplyGenerator.elRefToPath(t.nodeProperty())));
            if (!t.expandLevels().isEmpty()) {
                f.value("ExpandLevels", ApplyGenerator.expandLevelsToJson(t.expandLevels()));
            }
            if (t.levels() > 0L) {
                f.value("Levels", t.levels());
            }
            this.trafo = f;
        }

        public void visit(CqnAncestorsTransformation a) {
            this.sub((CqnHierarchySubsetTransformation)a, "ancestors");
        }

        public void visit(CqnDescendantsTransformation d) {
            this.sub((CqnHierarchySubsetTransformation)d, "descendants");
        }

        private void sub(CqnHierarchySubsetTransformation hSubset, String funcName) {
            int distanceFromStart;
            TrafoFunc f = TrafoFunc.create(funcName).value(ApplyGenerator.this.resourcePath()).value(hSubset.hierarchyQualifier()).value(ApplyGenerator.elRefToPath(hSubset.nodeProperty()));
            List swTrafos = hSubset.transformations();
            if (!swTrafos.isEmpty()) {
                String startWhereStr = swTrafos.stream().map(t -> ApplyGenerator.toTrafoString(t, this)).collect(Collectors.joining(TRAFO_DELIM));
                f.value(startWhereStr);
            }
            if ((distanceFromStart = hSubset.distanceFromStart()) != 0) {
                f.value(distanceFromStart);
            }
            if (hSubset.keepStart()) {
                f.value("keep start");
            }
            this.trafo = f;
        }
    }
}

