/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata;

import com.sap.cds.integration.cloudsdk.destination.RemoteServiceHttpClientProvider;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.OpenTelemetryUtils;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteODataClient {
    private static final Logger logger = LoggerFactory.getLogger(RemoteODataClient.class);
    private static final Logger loggerResponseErrors = LoggerFactory.getLogger((String)(RemoteODataClient.class.getName() + ".errors"));
    private static final String RESULT_CONTEXT_KEY = "result";

    public void processEvent(EventContext context, RequestExecutor executor, BiConsumer<Optional<Span>, String> attributesProvider) {
        String serviceName = context.getService().getName();
        CdsProperties.Remote.RemoteServiceConfig remoteServiceConfig = context.getCdsRuntime().getEnvironment().getCdsProperties().getRemote().getService(serviceName);
        ODataProtocol protocol = this.getProtocol(remoteServiceConfig);
        if (protocol == null) {
            return;
        }
        Optional span = OpenTelemetryUtils.createSpan((OpenTelemetryUtils.CdsSpanType)OpenTelemetryUtils.CdsSpanType.CQN);
        try (Scope scope = span.map(ImplicitContextKeyed::makeCurrent).orElse(null);){
            attributesProvider.accept(span, protocol == ODataProtocol.V2 ? "odata-v2" : "odata-v4");
            HttpClient client = RemoteServiceHttpClientProvider.getHttpClient((CdsProperties.Remote.RemoteServiceConfig)remoteServiceConfig, (CdsRuntime)context.getCdsRuntime());
            String servicePath = this.getServicePath(remoteServiceConfig.getHttp(), context);
            logger.debug("CQN >>{}<<", context.get("cqn"));
            Object result = this.handleExceptions(() -> executor.execute(client, remoteServiceConfig.getHttp(), protocol, servicePath));
            context.put(RESULT_CONTEXT_KEY, result);
            context.setCompleted();
        }
        catch (Exception e) {
            OpenTelemetryUtils.recordException((Optional)span, (Exception)e);
            throw e;
        }
        finally {
            OpenTelemetryUtils.endSpan((Optional)span);
        }
    }

    private String getServicePath(CdsProperties.Remote.RemoteServiceConfig.Http httpConfig, EventContext context) {
        Object servicePath = StringUtils.isEmpty((String)httpConfig.getService()) ? ((RemoteService)context.getService()).getDefinition().getQualifiedName() : httpConfig.getService().trim();
        if (!StringUtils.isEmpty((String)httpConfig.getSuffix())) {
            servicePath = httpConfig.getSuffix().trim() + "/" + (String)servicePath;
        }
        return servicePath;
    }

    private ODataProtocol getProtocol(CdsProperties.Remote.RemoteServiceConfig remoteServiceConfig) {
        if ("odata-v2".equalsIgnoreCase(remoteServiceConfig.getType())) {
            return ODataProtocol.V2;
        }
        if ("odata-v4".equalsIgnoreCase(remoteServiceConfig.getType())) {
            return ODataProtocol.V4;
        }
        return null;
    }

    private <T> T handleExceptions(Supplier<T> executor) {
        try {
            return executor.get();
        }
        catch (ODataResponseException e) {
            int statusCode = e.getHttpCode();
            String errorMessage = (String)e.getHttpBody().getOrElse((Object)"");
            if (statusCode >= 500 && statusCode < 600) {
                loggerResponseErrors.error("Received OData response with status code '{}' and error message '{}'", (Object)statusCode, (Object)errorMessage);
            } else {
                loggerResponseErrors.debug("Received OData response with status code '{}' and error message '{}'", (Object)statusCode, (Object)errorMessage);
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_ERROR_RESPONSE, new Object[]{statusCode, e});
        }
    }

    @FunctionalInterface
    public static interface RequestExecutor {
        public Object execute(HttpClient var1, CdsProperties.Remote.RemoteServiceConfig.Http var2, ODataProtocol var3, String var4);
    }
}

