/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.ql.cqn.CqnEntitySelector;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.odata.query.StructuredQueryBuilder;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExpandGenerator
implements AbstractGenerator,
CqnVisitor {
    private final List<StructuredQuery> expanded = new ArrayList<StructuredQuery>();
    private final Set<String> excluded = new HashSet<String>();
    private final CdsEntity entity;
    private final ConversionContext context;

    public ExpandGenerator(CdsEntity entity, ConversionContext context) {
        this.entity = entity;
        this.context = context;
    }

    public ExpandGenerator(CdsEntity entity, ConversionContext context, CqnSelect select) {
        this(entity, context);
        this.excluded.addAll(select.excluding());
    }

    public void visit(CqnExpand expand) {
        CqnStructuredTypeRef ref = expand.ref();
        if (ref.size() != 1) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_PATH_EXPR, new Object[0]);
        }
        ODataProtocol protocol = this.context.getProtocol();
        CdsEntity targetEntity = (CdsEntity)this.entity.getTargetOf(ref.firstSegment());
        StructuredQueryBuilder sqb = StructuredQueryBuilder.forSubquery(this.context, ref.firstSegment(), targetEntity);
        sqb.expand(expand.items());
        sqb.select(expand.items());
        if (protocol == ODataProtocol.V4 && !CdsModelUtils.isSingleValued((CdsType)this.entity.getAssociation(ref.firstSegment()).getType())) {
            sqb.filter(expand.ref().rootSegment().filter());
            sqb.orderBy(expand.orderBy());
            sqb.top((CqnEntitySelector)expand);
            sqb.skip((CqnEntitySelector)expand);
        }
        this.expanded.add(sqb.build());
    }

    public void visit(CqnSelect select) {
        throw new IllegalStateException();
    }

    @Override
    public void apply(StructuredQuery query) {
        this.expanded.removeIf(q -> this.excluded.contains(q.getEntityOrPropertyName()));
        if (this.expanded.size() > 0) {
            query.select(this.expanded.toArray(new StructuredQuery[this.expanded.size()]));
        }
    }
}

