/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.uri;

import com.sap.cds.CdsData;
import com.sap.cds.ql.cqn.CqnEtagPredicate;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.util.OccUtils;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ETagExtractor {
    public static final String METADATA_ETAG_KEY = "etag";
    private final ConversionContext context;

    private ETagExtractor(ConversionContext context) {
        this.context = context;
    }

    public static ETagExtractor create(ConversionContext context) {
        return new ETagExtractor(context);
    }

    public void setIfMatch(ODataRequestGeneric request, Optional<CqnPredicate> predicate) {
        this.setIfMatch(request, predicate, null);
    }

    public void setIfMatch(ODataRequestGeneric request, Optional<CqnPredicate> predicate, Map<String, Object> entry) {
        List<String> values = this.extractETagValues(predicate, entry);
        if (!values.isEmpty()) {
            request.setHeader("If-Match", values);
        }
    }

    private List<String> extractETagValues(Optional<CqnPredicate> predicate, Map<String, Object> entry) {
        CdsData cds;
        Object entryETag;
        Optional optETag = predicate.flatMap(OccUtils::eTagPredicate);
        if (optETag.isPresent()) {
            CqnListValue eTag = ((CqnEtagPredicate)optETag.get()).valueSet().asList();
            ArrayList<String> values = new ArrayList<String>(eTag.size());
            eTag.values().forEach(v -> {
                if (v.isLiteral()) {
                    values.add(v.asLiteral().value().toString());
                } else if (v.isParameter()) {
                    values.add(this.context.getParameterValue(v.asParameter()).toString());
                }
            });
            return values;
        }
        if (entry instanceof CdsData && (entryETag = (cds = (CdsData)entry).getMetadata(METADATA_ETAG_KEY)) != null) {
            return List.of(entryETag.toString());
        }
        return Collections.emptyList();
    }
}

