/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.utils;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cloud.sdk.cloudplatform.connectivity.CsrfTokenRetriever;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class ODataRequestUtils {
    public static void prepareQuery(StructuredQuery query, EventContext context) {
        ParameterInfo info = context.getParameterInfo();
        if (info.getValidFrom() != null && info.getValidTo() != null && info.getValidFrom().equals(info.getValidTo().minusMillis(1L))) {
            query.withCustomParameter("sap-valid-at", ODataRequestUtils.format(info.getValidFrom()));
        } else {
            if (info.getValidFrom() != null) {
                query.withCustomParameter("sap-valid-from", ODataRequestUtils.format(info.getValidFrom()));
            }
            if (info.getValidTo() != null) {
                query.withCustomParameter("sap-valid-to", ODataRequestUtils.format(info.getValidTo()));
            }
        }
        if (info.getLocale() != null) {
            query.withCustomParameter("sap-language", LocaleUtils.getLocaleStringForQuery((Locale)info.getLocale()));
        }
    }

    public static <T extends ODataRequestGeneric> T prepareRequest(T req, CdsProperties.Remote.RemoteServiceConfig.Http httpConfig, EventContext context) {
        ParameterInfo info = context.getParameterInfo();
        if (info.getLocale() != null) {
            req.addHeader("Accept-Language", info.getLocale().toLanguageTag());
        }
        httpConfig.getHeaders().forEach((arg_0, arg_1) -> req.addHeader(arg_0, arg_1));
        httpConfig.getQueries().forEach((k, v) -> req.addQueryParameter(k, ODataUriFactory.encodeQuery((String)v)));
        if (!httpConfig.getCsrf().isEnabled().booleanValue()) {
            req.setCsrfTokenRetriever(CsrfTokenRetriever.DISABLED_CSRF_TOKEN_RETRIEVER);
        }
        return req;
    }

    private static String format(Instant instant) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(instant.atZone(ZoneId.of("UTC")));
    }
}

