/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.BooleanFunction;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnBetweenPredicate;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.odata.utils.AbstractGenerator;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.impl.odata.utils.CqnToCloudSdkConverter;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterableComparisonAbsolute;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterableComparisonRelative;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBoolean;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueCollection;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import java.util.List;

public class FilterGenerator
implements AbstractGenerator,
CqnVisitor {
    private final CdsEntity entity;
    private final ConversionContext context;
    final Stack<ValueBoolean> expression = new Stack();

    public FilterGenerator(CdsEntity entity, ConversionContext context) {
        this.entity = entity;
        this.context = context;
    }

    public void visit(CqnComparisonPredicate comparison) {
        if (comparison.left().isList() && comparison.right().isList()) {
            CqnStatementUtils.unfold((CqnPredicate)comparison).accept((CqnVisitor)this);
            return;
        }
        CqnValue left = comparison.left();
        CqnValue right = comparison.right();
        CqnToCloudSdkConverter converter = new CqnToCloudSdkConverter(left, right, (CdsStructuredType)this.entity, this.context);
        converter.convert();
        Expressions.OperandSingle convLeft = converter.getLeft();
        Expressions.OperandSingle convRight = converter.getRight();
        try {
            switch (comparison.operator()) {
                case EQ: 
                case IS: {
                    this.expression.push((Object)((FilterableComparisonAbsolute)convLeft).equalTo((Expressions.Operand)convRight));
                    break;
                }
                case NE: 
                case IS_NOT: {
                    this.expression.push((Object)((FilterableComparisonAbsolute)convLeft).notEqualTo((Expressions.Operand)convRight));
                    break;
                }
                case GE: {
                    this.expression.push((Object)((FilterableComparisonRelative)convLeft).greaterThanEqual((Expressions.Operand)convRight));
                    break;
                }
                case GT: {
                    this.expression.push((Object)((FilterableComparisonRelative)convLeft).greaterThan((Expressions.Operand)convRight));
                    break;
                }
                case LE: {
                    this.expression.push((Object)((FilterableComparisonRelative)convLeft).lessThanEqual((Expressions.Operand)convRight));
                    break;
                }
                case LT: {
                    this.expression.push((Object)((FilterableComparisonRelative)convLeft).lessThan((Expressions.Operand)convRight));
                }
            }
        }
        catch (ClassCastException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_OPERATOR, new Object[]{comparison.operator(), e});
        }
    }

    public void visit(CqnBetweenPredicate b) {
        try {
            CqnValue v = b.value();
            FilterableComparisonRelative btwn = (FilterableComparisonRelative)CqnToCloudSdkConverter.convert(v, (CdsStructuredType)this.entity, this.context);
            Expressions.OperandSingle lo = CqnToCloudSdkConverter.convert((Object)b.low(), (CdsStructuredType)this.entity, v, this.context);
            Expressions.OperandSingle hi = CqnToCloudSdkConverter.convert((Object)b.high(), (CdsStructuredType)this.entity, v, this.context);
            this.expression.push((Object)btwn.greaterThanEqual((Expressions.Operand)lo).and(btwn.lessThanEqual((Expressions.Operand)hi)));
        }
        catch (ClassCastException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_OPERATOR, new Object[]{"between", e});
        }
    }

    public void visit(CqnConnectivePredicate connective) {
        List expressions = this.expression.pop(connective.predicates().size());
        ValueBoolean result = (ValueBoolean)expressions.get(0);
        block4: for (int i = 1; i < expressions.size(); ++i) {
            switch (connective.operator()) {
                case AND: {
                    result = result.and((ValueBoolean)expressions.get(i));
                    continue block4;
                }
                case OR: {
                    result = result.or((ValueBoolean)expressions.get(i));
                }
            }
        }
        this.expression.push((Object)result);
    }

    public void visit(CqnNegation neg) {
        this.expression.push((Object)((ValueBoolean)this.expression.pop()).not());
    }

    public void visit(CqnContainmentTest test) {
        if (test.caseInsensitive()) {
            Value val = (Value)test.value();
            Value term = (Value)test.term();
            test = (CqnContainmentTest)val.toUpper().contains(term.toUpper());
        }
        this.expression.push((Object)((ValueBoolean)CqnToCloudSdkConverter.convert(test, (CdsStructuredType)this.entity, this.context)));
    }

    public void visit(CqnInPredicate in) {
        try {
            if (this.context.getProtocol() == ODataProtocol.V2 || in.value().isList()) {
                CqnStatementUtils.unfold((CqnPredicate)in).accept((CqnVisitor)this);
            } else {
                FilterableComparisonAbsolute comparable = (FilterableComparisonAbsolute)CqnToCloudSdkConverter.convert(in.value(), (CdsStructuredType)this.entity, this.context);
                Expressions.Operand[] operands = (Expressions.Operand[])in.values().stream().map(v -> CqnToCloudSdkConverter.convert(v, (CdsStructuredType)this.entity, in.value(), this.context)).toArray(Expressions.Operand[]::new);
                ValueBoolean predicate = comparable.in(operands);
                this.expression.push((Object)predicate);
            }
        }
        catch (ClassCastException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_OPERATOR, new Object[]{"in", e});
        }
    }

    public void visit(CqnFunc func) {
        if (func instanceof BooleanFunction) {
            this.expression.push((Object)((ValueBoolean)CqnToCloudSdkConverter.convert(func, (CdsStructuredType)this.entity, this.context)));
        }
    }

    @Override
    public void apply(StructuredQuery query) {
        if (!this.expression.isEmpty()) {
            query.filter(new ValueBoolean[]{(ValueBoolean)this.expression.pop()});
        }
    }

    public void visit(CqnMatchPredicate query) {
        if (this.context.getProtocol() == ODataProtocol.V2) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_V2_LAMBDA, new Object[0]);
        }
        ValueCollection collection = CqnToCloudSdkConverter.convertRefToFieldUntyped((CqnReference)query.ref()).asCollection();
        if (query.predicate().isPresent()) {
            FilterGenerator generator = new FilterGenerator(CdsModelUtils.getRefTarget((CqnStructuredTypeRef)query.ref(), (CdsEntity)this.entity), this.context);
            ((CqnPredicate)query.predicate().get()).accept((CqnVisitor)generator);
            ValueBoolean odataQuery = (ValueBoolean)generator.expression.pop();
            switch (query.quantifier()) {
                case ANY: {
                    this.expression.push((Object)collection.any(odataQuery));
                    break;
                }
                case ALL: {
                    this.expression.push((Object)collection.all(odataQuery));
                }
            }
        } else {
            switch (query.quantifier()) {
                case ANY: {
                    this.expression.push((Object)collection.any());
                    break;
                }
                case ALL: {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_INVALID_LAMBDA_ALL, new Object[0]);
                }
            }
        }
    }

    public void visit(CqnSelect select) {
        throw new IllegalStateException();
    }

    @Override
    public String getExpression() {
        return ((ValueBoolean)this.expression.peek()).getExpression(this.context.getProtocol());
    }
}

