/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.query;

import com.sap.cds.impl.util.Stack;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.impl.odata.utils.ConversionContext;
import com.sap.cds.services.impl.odata.utils.CqnToCloudSdkConverter;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import java.util.List;
import java.util.Locale;

public class ValueGenerator
implements CqnVisitor {
    private Stack<String> s = new Stack();
    private final CdsEntity entity;
    private final ConversionContext context;

    public ValueGenerator(CdsEntity entity, ConversionContext context) {
        this.entity = entity;
        this.context = context;
    }

    public void visit(CqnSelectListValue slv) {
        slv.alias().ifPresent(a -> {
            String val = (String)this.s.pop();
            this.s.push(a);
            this.s.push((Object)"as");
            this.s.push((Object)val);
        });
    }

    public void visit(CqnFunc func) {
        CqnValue arg0;
        String methodName = func.func().toLowerCase(Locale.US);
        Object f = "count".equals(methodName) && func.args().isEmpty() ? "$count" : (ValueGenerator.isAggregateFunc(methodName) && func.args().size() == 1 ? ((arg0 = (CqnValue)func.args().get(0)).isRef() ? this.convertVal(arg0) : (String)this.s.pop()) + " with " + methodName : this.convertVal((CqnValue)func));
        this.s.push(f);
    }

    public void visit(CqnArithmeticExpression expr) {
        ValuePair pair = this.convertVals(expr.left(), expr.right());
        this.s.push((Object)(pair.lhs + " " + expr.operator().toString().toLowerCase(Locale.US) + " " + pair.rhs));
    }

    public void visit(CqnComparisonPredicate comp) {
        ValuePair pair = this.convertVals(comp.left(), comp.right());
        this.s.push((Object)(pair.lhs + " " + ValueGenerator.toValidOdataOperator(comp.operator()).toString().toLowerCase(Locale.US) + " " + pair.rhs));
    }

    private String convertVal(CqnValue val) {
        return CqnToCloudSdkConverter.convert(val, (CdsStructuredType)this.entity, this.context).getExpression(this.context.getProtocol());
    }

    private ValuePair convertVals(CqnValue lhs, CqnValue rhs) {
        CqnToCloudSdkConverter convrtr = new CqnToCloudSdkConverter(lhs, rhs, (CdsStructuredType)this.entity, this.context);
        convrtr.convert();
        ODataProtocol protocol = this.context.getProtocol();
        return new ValuePair(convrtr.getLeft().getExpression(protocol), convrtr.getRight().getExpression(protocol));
    }

    private static boolean isAggregateFunc(String func) {
        return switch (func) {
            case "avg", "average", "count", "countdistinct", "max", "min", "sum" -> true;
            default -> false;
        };
    }

    private static CqnComparisonPredicate.Operator toValidOdataOperator(CqnComparisonPredicate.Operator cqnOperator) {
        return switch (cqnOperator) {
            case CqnComparisonPredicate.Operator.IS -> CqnComparisonPredicate.Operator.EQ;
            case CqnComparisonPredicate.Operator.IS_NOT -> CqnComparisonPredicate.Operator.NE;
            default -> cqnOperator;
        };
    }

    public List<String> getResult() {
        return this.s.stream().toList();
    }

    private record ValuePair(String lhs, String rhs) {
    }
}

