/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.odata.utils;

import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.StreamUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;

public class MediaElementUtil {
    private MediaElementUtil() {
    }

    public static CdsElement getMediaElement(CdsEntity target, CqnSelect select) {
        String fileNameElement;
        ArrayList mediaElements = new ArrayList(1);
        select.items().stream().filter(CqnSelectListItem::isRef).forEach(r -> target.findElement(r.asRef().path()).filter(e -> CdsAnnotations.CORE_MEDIA_TYPE.getOrDefault((CdsAnnotatable)e) != null).ifPresent(mediaElements::add));
        if (mediaElements.size() != 1) {
            return null;
        }
        HashSet<String> expectedItems = new HashSet<String>(3);
        CdsElement mediaElement = (CdsElement)mediaElements.get(0);
        expectedItems.add(mediaElement.getName());
        String contentTypeElement = StreamUtils.getCoreMediaTypeElement((CdsAnnotatable)mediaElement);
        if (contentTypeElement != null) {
            expectedItems.add(contentTypeElement);
        }
        if ((fileNameElement = StreamUtils.getContentDispositionFilenameElement((CdsAnnotatable)mediaElement)) != null) {
            expectedItems.add(fileNameElement);
        }
        if (select.items().stream().allMatch(i -> i.isRef() && expectedItems.contains(i.asRef().path()))) {
            return mediaElement;
        }
        return null;
    }

    public static MediaElement getMediaElement(CdsEntity target, CqnUpdate update) {
        List payload = update.entries();
        if (payload.size() == 1) {
            Map map = (Map)payload.get(0);
            ArrayList mediaElements = new ArrayList(1);
            map.keySet().forEach(k -> target.findElement(k).filter(e -> CdsAnnotations.CORE_MEDIA_TYPE.getOrDefault((CdsAnnotatable)e) != null).ifPresent(mediaElements::add));
            if (mediaElements.size() != 1) {
                return null;
            }
            Set expectedFields = CdsModelUtils.keyNames((CdsStructuredType)target);
            CdsElement element = (CdsElement)mediaElements.get(0);
            expectedFields.add(element.getName());
            String mediaTypeElement = StreamUtils.getCoreMediaTypeElement((CdsAnnotatable)element);
            if (mediaTypeElement != null) {
                expectedFields.add(mediaTypeElement);
            }
            if (target.elements().filter(e -> !e.isKey() && !expectedFields.contains(e.getName())).noneMatch(e -> map.containsKey(e.getName()))) {
                return new MediaElement(element, map);
            }
        }
        return null;
    }

    public record MediaElement(CdsElement element, Map<String, Object> map) {
        public InputStream payload() {
            Object value = this.map.get(this.element.getName());
            if (value == null) {
                return null;
            }
            if (value instanceof InputStream) {
                InputStream stream = (InputStream)value;
                return stream;
            }
            if (value instanceof Reader) {
                Reader reader = (Reader)value;
                try {
                    return ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(reader)).get();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.REMOTE_ODATA_MEDIA_UNSUPPORTED_STREAMED_TYPE, new Object[]{this.element.getName(), value.getClass().getName()});
        }

        public String contentType() {
            String result = StreamUtils.getCoreMediaTypeElement((CdsAnnotatable)this.element);
            if (result != null) {
                return (String)DataUtils.getOrDefault(this.map, (String)result, null);
            }
            return StreamUtils.getCoreMediaTypeValue((CdsAnnotatable)this.element);
        }
    }
}

