/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.ucl.adapter;

import com.sap.cds.feature.ucl.adapter.SpiiRequest;
import com.sap.cds.feature.ucl.services.SpiiContext;
import com.sap.cds.feature.ucl.services.SpiiResult;
import com.sap.cds.feature.ucl.services.UclService;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.cert.CertValidator;
import com.sap.cds.services.utils.cert.UclAuthUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UclServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(UclServlet.class);
    private static final String METHOD_PATCH = "PATCH";
    private final UclService uclService;
    private final CdsRuntime runtime;
    private final CertValidator certValidator;

    public UclServlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.uclService = (UclService)runtime.getServiceCatalog().getService(UclService.class, "UclService$Default");
        this.certValidator = UclAuthUtils.createCertValidator((CdsRuntime)runtime);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if (method.equals(METHOD_PATCH)) {
            this.doPatch(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    protected void doPatch(HttpServletRequest req, HttpServletResponse res) {
        logger.debug("Received call in Spii tenant mapping");
        this.processRequest(req, res, p -> !p.isEmpty(), () -> {
            String tenantId = UclServlet.getTenantId(req);
            SpiiRequest spiiRequest = SpiiRequest.of((Map)JsonParser.map((Reader)new InputStreamReader((InputStream)req.getInputStream())));
            SpiiContext ctx = spiiRequest.getContext();
            logger.info("Performing operation '{}' for formation '{}' and tenant '{}'", new Object[]{ctx.getOperation(), ctx.getUclFormationName(), tenantId});
            String resultState = "CREATE_READY";
            Map<Object, Object> resultConfiguration = new HashMap();
            String operation = ctx.getOperation();
            if ("assign".equals(operation)) {
                try {
                    SpiiResult result = this.uclService.assign(tenantId, spiiRequest.getContext(), spiiRequest.getReceiverTenant(), spiiRequest.getAssignedTenant());
                    resultState = result.getReady() != false ? "CREATE_READY" : "CONFIG_PENDING";
                    resultConfiguration = result.getConfiguration();
                }
                catch (ServiceException e) {
                    logger.error("Error while processing operation '{}' for formation '{}' and '{}'", new Object[]{ctx.getOperation(), ctx.getUclFormationName(), tenantId, e});
                    resultState = "CREATE_ERROR";
                }
            } else if ("unassign".equals(operation)) {
                try {
                    this.uclService.unassign(tenantId, spiiRequest.getContext(), spiiRequest.getReceiverTenant(), spiiRequest.getAssignedTenant());
                    resultState = "DELETE_READY";
                }
                catch (ServiceException e) {
                    logger.error("Error while processing operation '{}' for formation '{}' and '{}'", new Object[]{ctx.getOperation(), ctx.getUclFormationName(), tenantId, e});
                    resultState = "DELETE_ERROR";
                }
            }
            res.setStatus(200);
            UclServlet.setContentType(res, ContentType.APPLICATION_JSON);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("state", resultState);
            response.put("configuration", resultConfiguration);
            Jsonizer.write((Writer)res.getWriter(), response);
        });
    }

    private static String getTenantId(HttpServletRequest req) {
        String[] segments = req.getPathInfo().split("/");
        if (segments.length < 2 || StringUtils.isEmpty((String)segments[1])) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[0]);
        }
        return segments[1];
    }

    private static void setContentType(HttpServletResponse resp, ContentType contType) {
        resp.setContentType(contType.getMimeType());
        resp.setCharacterEncoding(contType.getCharset().toString());
    }

    private static void handleException(HttpServletResponse res, Locale locale, ServiceException e) {
        block10: {
            if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                logger.error("Unexpected error", (Throwable)e);
            } else {
                logger.debug("Service exception thrown", (Throwable)e);
            }
            res.setStatus(e.getErrorStatus().getHttpStatus());
            try {
                String message = e.getLocalizedMessage(locale);
                if (message == null) break block10;
                try (PrintWriter writer = res.getWriter();){
                    writer.write(message);
                }
            }
            catch (IOException e1) {
                logger.error("Failed to write error message to response", (Throwable)e1);
            }
        }
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse res, Predicate<String> pathMatcher, Processor processor) {
        if (pathMatcher.test(req.getPathInfo())) {
            try {
                UclAuthUtils.checkAuthorization((CertValidator)this.certValidator, (CdsRuntime)this.runtime);
            }
            catch (ServiceException e) {
                UclServlet.handleException(res, null, e);
                return;
            }
            catch (Throwable t) {
                logger.error("Unexpected error", t);
                res.setStatus(500);
                return;
            }
            this.runtime.requestContext().systemUserProvider().run(requestContext -> {
                try {
                    processor.process();
                }
                catch (ServiceException e) {
                    UclServlet.handleException(res, requestContext.getParameterInfo().getLocale(), e);
                }
                catch (Throwable t) {
                    logger.error("Unexpected error", t);
                    res.setStatus(500);
                }
            });
        } else {
            res.setStatus(404);
        }
    }

    @FunctionalInterface
    private static interface Processor {
        public void process() throws IOException;
    }
}

