/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.feature.ucl.adapter;

import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.path.UrlPathUtil;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;

/**
 * Factory for the Unified Customer Landscape adapter.
 */
public class UclAdapterFactory implements ServletAdapterFactory, CdsRuntimeAware {

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Object create() {
		return new UclServlet(runtime);
	}

	@Override
	public boolean isEnabled() {
		return runtime.getEnvironment().getCdsProperties().getUcl().getEndpoint().isEnabled();
	}

	@Override
	public String getBasePath() {
		return UrlPathUtil.normalizeBasePath(runtime.getEnvironment().getCdsProperties().getUcl().getEndpoint().getPath());
	}

	@Override
	public String[] getMappings() {
		return new String[] { UrlResourcePathBuilder.path(getBasePath()).recursive().build().getPath() };
	}

	@Override
	public UrlResourcePath getServletPath() {
		// Certificate is checked by service handler (authentication + authorization)
		return UrlResourcePathBuilder.path(getBasePath()).recursive().isPublic(true).build();
	}

}
